package com.ejie.ab18a.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab18a.combo.Ab18aObjetoWSBean;
import com.ejie.ab18a.entidades.Ab18aUsuario;
import com.ejie.ab18a.model.Ab18aEnvio;
import com.ejie.ab18a.model.Ab18aFiltroMonitor;
import com.ejie.ab18a.model.Ab18aIncoherencia;
import com.ejie.ab18a.model.Ab18aPeticionDetalle;
import com.ejie.ab18a.model.Ab18aPeticionEnvio;
import com.ejie.ab18a.utils.Constantes;
import com.ejie.ab18a.utils.Utilidades;
import com.ejie.ab18a.ws.model.Ab18aDatosRespuestaEsentool;
import com.ejie.ab18a.ws.model.Ab18aValidacionBoletin;
import com.ejie.ab18a.ws.model.DatosBoletin;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import com.ejie.xmlbeans.TipoEntidadImpulsora;
import com.ejie.xmlbeans.TipoPerfil;
import com.ejie.xmlbeans.TipoPoder;

/**
 * Ab18a01s00DaoImpl generated by XXXX, 03-feb-2017 12:02:31.
 * 
 * @author XXXX
 */

@Repository
@Transactional
public class Ab18aPeticionEnvioDaoImpl implements Ab18aPeticionEnvioDao {
	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Ab18aPeticionEnvio> rwMap = new RowMapper<Ab18aPeticionEnvio>() {
		public Ab18aPeticionEnvio mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Ab18aPeticionEnvio(resultSet.getInt("T01IDPETICIONENVIO"), null, null, null, null, null, null, null, null, null, null, null,
					null, null, null);
		}
	};

	private RowMapper<Ab18aPeticionDetalle> rwMapDetalle = new RowMapper<Ab18aPeticionDetalle>() {
		public Ab18aPeticionDetalle mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Ab18aPeticionDetalle(resultSet.getInt("T01IDPETICIONENVIO"), null, resultSet.getString("TIPOENVIODESC"), null,
					resultSet.getString("BOLETINDESC"), null, resultSet.getString("DESCESTADO"), resultSet.getDate("FECHAALTA"),
					resultSet.getDate("FECHAPROG"), null, resultSet.getString("DESCESTADOTRAM"), resultSet.getString("CODEXPEDIENTE"),
					new Ab18aDatosRespuestaEsentool(resultSet.getString("IDENVIOWS"), null, resultSet.getString("ESTADOENVIO"), resultSet
							.getString("ERRORENVIO"), null, resultSet.getDate("FECHARECEP"), resultSet.getDate("FECHAMODIF"), resultSet
							.getDate("FECHAPUBLIC"), resultSet.getString("CODPUBLICACION"), null));
		}
	};

	private RowMapper<Ab18aPeticionEnvio> rwMapZip = new RowMapper<Ab18aPeticionEnvio>() {
		public Ab18aPeticionEnvio mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Ab18aPeticionEnvio(resultSet.getInt("T01IDPETICIONENVIO"), null, null, resultSet.getBytes("T01ANUNCIOZIP"), null, null, null,
					null, null, null, null, null, null, null, null);
		}
	};

	private RowMapper<Ab18aEnvio> rwMapEnvio = new RowMapper<Ab18aEnvio>() {
		public Ab18aEnvio mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Ab18aEnvio(resultSet.getString("CODEXPEDIENTE"), resultSet.getString("DESCBOLETIN"), null, resultSet.getInt("IDPETICION"),
					resultSet.getString("DESCTIPOENVIO"), null, resultSet.getDate("FECHAENVIO"), resultSet.getDate("fechaProgramadaPublicacion"),
					resultSet.getDate("FECHAPUBLICACION"), resultSet.getString("ESTADOPETICION"), resultSet.getInt("IDESTADOPETICION"),
					resultSet.getInt("PARALIZADO"));
		}
	};

	private RowMapper<DatosBoletin> rwMapBoletin = new RowMapper<DatosBoletin>() {
		public DatosBoletin mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new DatosBoletin(resultSet.getInt("T01IDPETICIONENVIO"), resultSet.getString("T11CODESTADO"),
					resultSet.getString("T11DESCESTADO"), resultSet.getDate("T01FECHAALTA"), null, null, null, null,
					resultSet.getString("T01ANUNCIOXML"), resultSet.getString("T01ANUNCIOXMLCON"), resultSet.getString("T01IDPODER"),
					resultSet.getString("T01IDENTIDADIMP"), resultSet.getString("T01IDORGANO"), resultSet.getString("T01IDENTIDADTRAM"),
					resultSet.getString("T01IDMESA"), null, resultSet.getString("T01CODEXPEDIENTE"), null, resultSet.getLong("T01IDORIGEN"),
					resultSet.getInt("T03ORIGENAPP"), resultSet.getString("T01RESULTVALIDLOGICA"), resultSet.getString("T17CODERROR"),
					resultSet.getString("T17DESCERROR"));
		}
	};

	private RowMapper<Ab18aPeticionEnvio> rwMapPK = new RowMapper<Ab18aPeticionEnvio>() {
		public Ab18aPeticionEnvio mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Ab18aPeticionEnvio();
		}
	};

	private RowMapper<String> rwMapString = new RowMapper<String>() {
		public String mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new String(resultSet.getString("CODDEPARTAMENTO"));
		}
	};

	private RowMapper<Integer> rwMapInteger = new RowMapper<Integer>() {
		public Integer mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Integer(resultSet.getInt("NUMINTENTOS"));
		}
	};

	private RowMapper<Ab18aIncoherencia> rwMapIncoherencias = new RowMapper<Ab18aIncoherencia>() {
		public Ab18aIncoherencia mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Ab18aIncoherencia(resultSet.getInt("T18IDINCO"), resultSet.getString("T18CODEXP"), null, resultSet.getString("T19DESCTIPO"),
					null);
		}
	};

	private RowMapper<Ab18aDatosRespuestaEsentool> rwMapInvocacion = new RowMapper<Ab18aDatosRespuestaEsentool>() {
		public Ab18aDatosRespuestaEsentool mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Ab18aDatosRespuestaEsentool(resultSet.getString("IDENVIOWS"), resultSet.getString("CODENVIOWS"),
					resultSet.getString("ESTADOENVIOWS"), resultSet.getString("ERRORENVIOWS"), null, resultSet.getDate("FECHAENVIO"),
					resultSet.getDate("FECHAMODIF"), resultSet.getDate("FECHAPUBLICACION"), resultSet.getString("CODPUBLICACION"),
					resultSet.getString("NODOCOJS"));
		}
	};

	private RowMapper<Ab18aValidacionBoletin> rwMapValidacion = new RowMapper<Ab18aValidacionBoletin>() {
		public Ab18aValidacionBoletin mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Ab18aValidacionBoletin(resultSet.getString("DESCTIPOVALID"), resultSet.getString("NOMBREVALID"),
					resultSet.getString("MENSAJE"), resultSet.getString("DETALLE"), resultSet.getString("SUPERA"), resultSet.getString("SEVERIDAD"));
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	private RowMapper<JerarquiaDto<Ab18aPeticionEnvio>> rwMapJerarquia = new RowMapper<JerarquiaDto<Ab18aPeticionEnvio>>() {
		public JerarquiaDto<Ab18aPeticionEnvio> mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			Ab18aPeticionEnvio ab18a01s00 = new Ab18aPeticionEnvio();

			JerarquiaDto<Ab18aPeticionEnvio> jerarquia = new JerarquiaDto<Ab18aPeticionEnvio>();
			jerarquia.setModel(ab18a01s00);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet.getString("FILTER")));
			return jerarquia;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */
	/**
	 * @param secuencia
	 *            String
	 * @return String
	 * @throws Exception
	 *             the exception
	 */
	public int getNextSequenceValue(String secuencia) throws Exception {
		Integer sequenceValue = -1;
		try {
			String query = "SELECT " + secuencia + ".NEXTVAL FROM DUAL";
			sequenceValue = this.jdbcTemplate.queryForInt(query);
		} catch (Exception e) {
			throw new Exception(e.getMessage());
		}
		return sequenceValue;
	}

	/**
	 * Inserts a single row in the Ab18a01s00 table.
	 * 
	 * @param peticionEnvio
	 *            Ab18aPeticionEnvio
	 * @return Ab18aPeticionEnvio
	 * @throws Exception
	 *             the exception
	 */
	public Ab18aPeticionEnvio add(Ab18aPeticionEnvio peticionEnvio) throws Exception {

		try {
			peticionEnvio.setT01IdPeticionEnvio(this.getNextSequenceValue("SQAB18A01"));
		} catch (Exception e) {
			throw new Exception(e.getMessage());
		}

		String query = "INSERT INTO AB18A01S00 (T01_ID_PETICION_ENVIO, "
				+ "T06_ID_BOLETIN, "
				+ "T03_ID_APLICACION, T01_FECHA_ALTA, "
				+ "T01_ANUNCIO_ZIP, "
				+ "T01_ANUNCIO_XML, "
				+ "T01_ANUNCIO_XML_CONVERTIDO, "
				+ "T02_ID_TIPO_ENVIO, "
				+ "T01_FECHA_PROGR_ENVIO, "
				+ "T01_ID_PODER,"
				+ "T01_ID_ENTIDAD_IMP, T01_ID_ORGANO, "
				+ "T01_ID_ENTIDAD_TRAM, "
				+ "T01_ID_MESA, "
				+ "T01_ESTADO_TRAM, T01_COD_EXPEDIENTE, T07_ID_TICKET, T11_ID_ESTADO, T01_ID_ORIGEN, T01_PARALIZADA) VALUES (?,?,?,sysdate,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

		this.jdbcTemplate.update(query, peticionEnvio.getT01IdPeticionEnvio(), peticionEnvio.getT06IdBoletin(), peticionEnvio.getT03IdOrigen(),
				peticionEnvio.getT01AnuncioZip(), peticionEnvio.getT01AnuncioXml(), peticionEnvio.getT01AnuncioXmlConvertido(),
				peticionEnvio.getT02TipoEnvio(), peticionEnvio.getT01FechaProgrEnvio(), peticionEnvio.getT01IdPoder(),
				peticionEnvio.getT01IdEntidadImp(), peticionEnvio.getT01IdOrgano(), peticionEnvio.getT01IdEntidadTramitadora(),
				peticionEnvio.getT01IdMesa(), peticionEnvio.getT01EstadoTramitacion(), peticionEnvio.getT01CodExpContratacion(),
				peticionEnvio.getT07IdTicket(), peticionEnvio.getT11IdEstado(), peticionEnvio.getT01IdOrigen(), peticionEnvio.getT01Paralizada());

		return peticionEnvio;
	}

	/**
	 * Updates a single row in the Ab18a01s00 table.
	 * 
	 * @param ab18a01s00
	 *            Ab18a01s00
	 * @return Ab18a01s00
	 */
	public Ab18aPeticionEnvio update(Ab18aPeticionEnvio ab18a01s00) {
		// String query =
		// "UPDATE AB18A01S00 SET T06_ID_BOLETIN=?, T02_ID_TIPO_ENVIO=?, T07_ID_TICKET=?, T03_ID_APLICACION=?, T11_ID_ESTADO=?, T01_FECHA_ALTA=?, T01_ANUNCIO_ZIP=?, T01_ANUNCIO_XML=?, T01_ID_PODER=?, T01_ID_ENTIDAD_IMP=?, T01_ID_ORGANO=?, T01_ID_ENTIDAD_TRAM=?, T01_ID_MESA=?, T01_FECHA_PROGR_ENVIO=?, T01_NUM_INTENTOS=?, T01_DATOS_ERROR=?, T01_ESTADO_TRAM=?, T01_COD_EXPEDIENTE=?, T01_RESULT_VALID_LOGICA=?, T01_ANUNCIO_XML_CONVERTIDO=? WHERE T01_ID_PETICION_ENVIO=?";
		// Object getAb18a06s00T06IdBoletinAux = null;
		// if (ab18a01s00.getAb18a06s00() != null
		// && ab18a01s00.getAb18a06s00().getT06IdBoletin() != null) {
		// getAb18a06s00T06IdBoletinAux = ab18a01s00.getAb18a06s00()
		// .getT06IdBoletin();
		// }
		// Object getAb18a02s00T02IdTipoEnvioAux = null;
		// if (ab18a01s00.getAb18a02s00() != null
		// && ab18a01s00.getAb18a02s00().getT02IdTipoEnvio() != null) {
		// getAb18a02s00T02IdTipoEnvioAux = ab18a01s00.getAb18a02s00()
		// .getT02IdTipoEnvio();
		// }
		// Object getAb18a07s00T07IdTicketAux = null;
		// if (ab18a01s00.getAb18a07s00() != null
		// && ab18a01s00.getAb18a07s00().getT07IdTicket() != null) {
		// getAb18a07s00T07IdTicketAux = ab18a01s00.getAb18a07s00()
		// .getT07IdTicket();
		// }
		// Object getAb18a03s00T03IdAplicacionAux = null;
		// if (ab18a01s00.getAb18a03s00() != null
		// && ab18a01s00.getAb18a03s00().getT03IdAplicacion() != null) {
		// getAb18a03s00T03IdAplicacionAux = ab18a01s00.getAb18a03s00()
		// .getT03IdAplicacion();
		// }
		// Object getAb18a11s00T11IdEstadoAux = null;
		// if (ab18a01s00.getAb18a11s00() != null
		// && ab18a01s00.getAb18a11s00().getT11IdEstado() != null) {
		// getAb18a11s00T11IdEstadoAux = ab18a01s00.getAb18a11s00()
		// .getT11IdEstado();
		// }
		// this.jdbcTemplate.update(query, getAb18a06s00T06IdBoletinAux,
		// getAb18a02s00T02IdTipoEnvioAux, getAb18a07s00T07IdTicketAux,
		// getAb18a03s00T03IdAplicacionAux, getAb18a11s00T11IdEstadoAux,
		// ab18a01s00.getT01FechaAlta(), ab18a01s00.getT01AnuncioZip(),
		// ab18a01s00.getT01AnuncioXml(), ab18a01s00.getT01IdPoder(),
		// ab18a01s00.getT01IdEntidadImp(), ab18a01s00.getT01IdOrgano(),
		// ab18a01s00.getT01IdEntidadTram(), ab18a01s00.getT01IdMesa(),
		// ab18a01s00.getT01FechaProgrEnvio(),
		// ab18a01s00.getT01NumIntentos(), ab18a01s00.getT01DatosError(),
		// ab18a01s00.getT01EstadoTram(),
		// ab18a01s00.getT01CodExpediente(),
		// ab18a01s00.getT01ResultValidLogica(),
		// ab18a01s00.getT01AnuncioXmlConvertido(),
		// ab18a01s00.getT01IdPeticionEnvio());
		return ab18a01s00;
	}

	/**
	 * Finds a single row in the Ab18a01s00 table.
	 * 
	 * @param ab18a01s00
	 *            Ab18a01s00
	 * @return Ab18a01s00
	 */
	@Transactional(readOnly = true)
	public Ab18aPeticionEnvio find(Ab18aPeticionEnvio ab18a01s00) {
		String query = "SELECT t1.T01_ID_PETICION_ENVIO T01IDPETICIONENVIO, t1.T01_FECHA_ALTA T01FECHAALTA, t1.T01_ANUNCIO_ZIP T01ANUNCIOZIP, t1.T01_ANUNCIO_XML T01ANUNCIOXML, t1.T01_ID_PODER T01IDPODER, t1.T01_ID_ENTIDAD_IMP T01IDENTIDADIMP, t1.T01_ID_ORGANO T01IDORGANO, t1.T01_ID_ENTIDAD_TRAM T01IDENTIDADTRAM, t1.T01_ID_MESA T01IDMESA, t1.T01_FECHA_PROGR_ENVIO T01FECHAPROGRENVIO, t1.T01_NUM_INTENTOS T01NUMINTENTOS, t1.T01_DATOS_ERROR T01DATOSERROR, t1.T01_ESTADO_TRAM T01ESTADOTRAM, t1.T01_COD_EXPEDIENTE T01CODEXPEDIENTE, t1.T01_RESULT_VALID_LOGICA T01RESULTVALIDLOGICA, t1.T01_ANUNCIO_XML_CONVERTIDO T01ANUNCIOXMLCONVERTIDO, t2.T06_ID_BOLETIN AB18A06S00T06IDBOLETIN, t2.T06_DESC AB18A06S00T06DESC, t2.T06_LOGIN AB18A06S00T06LOGIN, t2.T06_PASS AB18A06S00T06PASS, t2.T06_FECHA_ULT_MODIF AB18A06S00T06FECHAULTMODIF, t3.T02_ID_TIPO_ENVIO AB18A02S00T02IDTIPOENVIO, t3.T02_DESC_ES AB18A02S00T02DESCES, t3.T02_DESC_EU AB18A02S00T02DESCEU, t3.T02_FECHA_BAJA AB18A02S00T02FECHABAJA, t4.T07_ID_TICKET AB18A07S00T07IDTICKET, t4.T07_TICKET AB18A07S00T07TICKET, t4.T07_FECHA_PETICION AB18A07S00T07FECHAPETICION, t5.T03_ID_APLICACION AB18A03S00T03IDAPLICACION, t5.T03_MODO_RECEPCION AB18A03S00T03MODORECEPCION, t5.T03_DESC_ES AB18A03S00T03DESCES, t5.T03_DESC_EU AB18A03S00T03DESCEU, t6.T11_ID_ESTADO AB18A11S00T11IDESTADO, t6.T11_DESC_ESTADO AB18A11S00T11DESCESTADO, t7.T01_ID_PETICION_ENVIO AB18A14S00T01IDPETICIONENVIO, t7.T14_ID_PUBLICACION_WS AB18A14S00T14IDPUBLICACIONWS, t7.T14_FECHA_PUBLICACION_WS AB18A14S00T14FECHAPUBLICACIONWS, t7.T14_COD_DOC_PUBLICACION_WS AB18A14S00T14CODDOCPUBLICACIONWS, t4.T03_ID_APLICACION AB18A07S00T03IDAPLICACION FROM AB18A01S00 t1 , AB18A06S00 t2 , AB18A02S00 t3 , AB18A07S00 t4 , AB18A03S00 t5 , AB18A11S00 t6 , AB18A14S00 t7  WHERE t1.T01_ID_PETICION_ENVIO = ?   AND t1.T06_ID_BOLETIN= t2.T06_ID_BOLETIN(+) AND t1.T02_ID_TIPO_ENVIO= t3.T02_ID_TIPO_ENVIO(+) AND t1.T07_ID_TICKET= t4.T07_ID_TICKET(+) AND t1.T03_ID_APLICACION= t5.T03_ID_APLICACION(+) AND t1.T11_ID_ESTADO= t6.T11_ID_ESTADO(+) AND t1.T01_ID_PETICION_ENVIO= t7.T01_ID_PETICION_ENVIO(+)";

		List<Ab18aPeticionEnvio> ab18a01s00List = this.jdbcTemplate.query(query, this.rwMap, ab18a01s00.getT01IdPeticionEnvio());
		return (Ab18aPeticionEnvio) DataAccessUtils.uniqueResult(ab18a01s00List);
	}

	/**
	 * Finds a single row in the Ab18a01s00 table.
	 * 
	 * @param ab18a01s00
	 *            Ab18a01s00
	 * @return DatosBoletin
	 */
	@Transactional(readOnly = true)
	public DatosBoletin findPeticionRecogida(Ab18aPeticionEnvio ab18a01s00) {
		StringBuilder query = new StringBuilder("SELECT t1.T01_ID_PETICION_ENVIO T01IDPETICIONENVIO, ");
		query.append("t1.T01_ID_ORIGEN T01IDORIGEN, ");
		query.append("t1.T03_ID_APLICACION T03ORIGENAPP, ");
		query.append("t4.T11_COD_ESTADO T11CODESTADO, ");
		query.append("t4.T11_DESC_ESTADO T11DESCESTADO, ");
		query.append("t1.T01_FECHA_ALTA T01FECHAALTA, ");
		query.append("t1.T01_ANUNCIO_XML T01ANUNCIOXML, ");
		query.append("t1.T01_ANUNCIO_XML_CONVERTIDO T01ANUNCIOXMLCON, ");
		query.append("t1.T01_ID_PODER T01IDPODER, ");
		query.append("t1.T01_ID_ENTIDAD_IMP T01IDENTIDADIMP, ");
		query.append("t1.T01_ID_ORGANO T01IDORGANO, ");
		query.append("t1.T01_ID_ENTIDAD_TRAM T01IDENTIDADTRAM, ");
		query.append("t1.T01_ID_MESA T01IDMESA, ");
		query.append("t1.T01_COD_EXPEDIENTE T01CODEXPEDIENTE, ");
		query.append("t1.T01_RESULT_VALID_LOGICA T01RESULTVALIDLOGICA, ");
		query.append("t5.T17_COD_ERROR_VALIDACION T17CODERROR, ");
		query.append("t5.T17_DESC_ERROR_VALIDACION T17DESCERROR ");
		query.append("FROM AB18A01S00 t1 ");
		query.append("INNER JOIN AB18A11S00 t4 ON t1.T11_ID_ESTADO = t4.T11_ID_ESTADO ");
		query.append("LEFT OUTER JOIN AB18A17S00 t5 ON t1.T17_ID_ERROR_VALIDACION = t5.T17_ID_ERROR_VALIDACION ");
		query.append("WHERE t1.T01_ID_PETICION_ENVIO = ? AND t1.T03_ID_APLICACION = ? AND t1.T01_ID_ORIGEN = ? AND t1.T07_ID_TICKET = ?");

		List<DatosBoletin> ab18a01s00List = this.jdbcTemplate.query(query.toString(), this.rwMapBoletin, ab18a01s00.getT01IdPeticionEnvio(),
				ab18a01s00.getT03IdOrigen(), ab18a01s00.getT01IdOrigen(), ab18a01s00.getT07IdTicket());
		return (DatosBoletin) DataAccessUtils.uniqueResult(ab18a01s00List);
	}

	/**
	 * Finds a single row in the Ab18a01s00 table.
	 * 
	 * @param idPeticionEnvio
	 *            Integer
	 * @return DatosBoletin
	 */
	@Transactional(readOnly = true)
	public DatosBoletin findPeticionById(Integer idPeticionEnvio) {
		StringBuilder query = new StringBuilder("SELECT t1.T01_ID_PETICION_ENVIO T01IDPETICIONENVIO, ");
		query.append("t1.T01_ID_ORIGEN T01IDORIGEN, ");
		query.append("t1.T03_ID_APLICACION T03ORIGENAPP, ");
		query.append("t4.T11_COD_ESTADO T11CODESTADO, ");
		query.append("t4.T11_DESC_ESTADO T11DESCESTADO, ");
		query.append("t1.T01_FECHA_ALTA T01FECHAALTA, ");
		query.append("t1.T01_ANUNCIO_XML T01ANUNCIOXML, ");
		query.append("t1.T01_ANUNCIO_XML_CONVERTIDO T01ANUNCIOXMLCON, ");
		query.append("t1.T01_ID_PODER T01IDPODER, ");
		query.append("t1.T01_ID_ENTIDAD_IMP T01IDENTIDADIMP, ");
		query.append("t1.T01_ID_ORGANO T01IDORGANO, ");
		query.append("t1.T01_ID_ENTIDAD_TRAM T01IDENTIDADTRAM, ");
		query.append("t1.T01_ID_MESA T01IDMESA, ");
		query.append("t1.T01_COD_EXPEDIENTE T01CODEXPEDIENTE, ");
		query.append("t1.T01_RESULT_VALID_LOGICA T01RESULTVALIDLOGICA, ");
		query.append("t5.T17_COD_ERROR_VALIDACION T17CODERROR, ");
		query.append("t5.T17_DESC_ERROR_VALIDACION T17DESCERROR ");
		query.append("FROM AB18A01S00 t1 ");
		query.append("LEFT OUTER JOIN AB18A17S00 t5 ON t1.T17_ID_ERROR_VALIDACION = t5.T17_ID_ERROR_VALIDACION ");
		query.append("INNER JOIN AB18A11S00 t4 ON t1.T11_ID_ESTADO = t4.T11_ID_ESTADO WHERE t1.T01_ID_PETICION_ENVIO = ?");

		// t2.T13_FECHA_RECEP_WS T13FECHAENVIO, t2.T13_FECHA_MODIF_ENVIO_WS
		// T13FECHAACT
		List<DatosBoletin> ab18a01s00List = this.jdbcTemplate.query(query.toString(), this.rwMapBoletin, idPeticionEnvio);
		return (DatosBoletin) DataAccessUtils.uniqueResult(ab18a01s00List);
	}

	/**
	 * Finds a single row in the Ab18a01s00 table.
	 * 
	 * @param idPeticionEnvio
	 *            id de la peticion de envio
	 * @return Ab18aDatosRespuestaEsentool
	 */
	@Transactional(readOnly = true)
	public Ab18aDatosRespuestaEsentool findRespuestaWS(Integer idPeticionEnvio) {
		String query = "SELECT t1.T13_ID_ENVIO_WS IDENVIOWS, t1.T13_FECHA_RECEP_WS FECHAENVIO, t1.T13_FECHA_MODIF_ENVIO_WS FECHAMODIF, "
				+ "t1.T13_ESTADO_ENVIO_WS ESTADOENVIOWS, t1.T13_ERROR_ENVIO_WS ERRORENVIOWS, t1.T13_COD_ENVIO_WS CODENVIOWS, t2.T14_FECHA_PUBLICACION_WS FECHAPUBLICACION, t2.T14_COD_DOC_PUBLICACION_WS CODPUBLICACION, t2.T14_ID_PUBLICACION_WS NODOCOJS FROM AB18A13S00 t1 "
				+ "LEFT OUTER JOIN AB18A14S00 t2 ON t1.T01_ID_PETICION_ENVIO = t2.T01_ID_PETICION_ENVIO WHERE t1.T01_ID_PETICION_ENVIO = ?";

		List<Ab18aDatosRespuestaEsentool> invocacionList = this.jdbcTemplate.query(query, this.rwMapInvocacion, idPeticionEnvio);
		return (Ab18aDatosRespuestaEsentool) DataAccessUtils.uniqueResult(invocacionList);
	}

	/**
	 * Encuentra registros en la tabla AB18A08T00.
	 * 
	 * @param idPeticionEnvio
	 *            id de la peticion de envio
	 * @return Ab18aDatosRespuestaEsentool
	 */
	@Transactional(readOnly = true)
	public List<String> findTedLinks(Integer idPeticionEnvio) {
		String query = "SELECT T08_LINK LINK FROM AB18A08S00 WHERE T01_ID_PETICION_ENVIO = ?";
		List<String> listaTedLinks = this.jdbcTemplate.query(query, new RowMapper<String>() {
			public String mapRow(ResultSet rs, int rowNum) throws SQLException {
				return rs.getString("LINK");
			}
		}, idPeticionEnvio);

		return listaTedLinks;
	}

	/**
	 * Finds a list of rows in the Ab18a09s00 table.
	 * 
	 * @param idPeticionEnvio
	 *            id de la peticion de envio
	 * @return Ab18aValidacionBoletin
	 */
	public List<Ab18aValidacionBoletin> findValidaciones(Integer idPeticionEnvio) {
		String query = "SELECT t2.T10_DESC_TIPO_VALID DESCTIPOVALID, t1.T09_NOMBRE_VALID NOMBREVALID, t1.T09_SUPERA SUPERA, t1.T09_SEVERIDAD SEVERIDAD, t1.T09_MENSAJE MENSAJE, t1.T09_DETALLES DETALLE FROM AB18A09S00 t1 INNER JOIN AB18A10S00 t2 ON t1.T10_ID_TIPO_VALIDACION = t2.T10_ID_TIPO_VALIDACION WHERE T01_ID_PETICION_ENVIO = ?";
		List<Ab18aValidacionBoletin> validacionesList = this.jdbcTemplate.query(query, this.rwMapValidacion, idPeticionEnvio);
		return validacionesList;
	}

	/**
	 * Removes a single row in the Ab18a01s00 table.
	 * 
	 * @param ab18a01s00
	 *            Ab18a01s00
	 * @return
	 */
	public void remove(Ab18aPeticionEnvio ab18a01s00) {
		String query = "DELETE FROM AB18A01S00 WHERE T01_ID_PETICION_ENVIO=?";
		this.jdbcTemplate.update(query, ab18a01s00.getT01IdPeticionEnvio());
	}

	/**
	 * Finds a list of rows in the Ab18a01s00 table.
	 * 
	 * @param ab18a01s00
	 *            Ab18a01s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Ab18a01s00>
	 */
	@Transactional(readOnly = true)
	public List<Ab18aPeticionEnvio> findAll(Ab18aPeticionEnvio ab18a01s00, JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.T01_ID_PETICION_ENVIO T01IDPETICIONENVIO,t1.T01_FECHA_ALTA T01FECHAALTA,t1.T01_ANUNCIO_ZIP T01ANUNCIOZIP,t1.T01_ANUNCIO_XML T01ANUNCIOXML,t1.T01_ID_PODER T01IDPODER,t1.T01_ID_ENTIDAD_IMP T01IDENTIDADIMP,t1.T01_ID_ORGANO T01IDORGANO,t1.T01_ID_ENTIDAD_TRAM T01IDENTIDADTRAM,t1.T01_ID_MESA T01IDMESA,t1.T01_FECHA_PROGR_ENVIO T01FECHAPROGRENVIO,t1.T01_NUM_INTENTOS T01NUMINTENTOS,t1.T01_DATOS_ERROR T01DATOSERROR,t1.T01_ESTADO_TRAM T01ESTADOTRAM,t1.T01_COD_EXPEDIENTE T01CODEXPEDIENTE,t1.T01_RESULT_VALID_LOGICA T01RESULTVALIDLOGICA,t1.T01_ANUNCIO_XML_CONVERTIDO T01ANUNCIOXMLCONVERTIDO,t2.T06_ID_BOLETIN AB18A06S00T06IDBOLETIN,t2.T06_DESC AB18A06S00T06DESC,t2.T06_LOGIN AB18A06S00T06LOGIN,t2.T06_PASS AB18A06S00T06PASS,t2.T06_FECHA_ULT_MODIF AB18A06S00T06FECHAULTMODIF,t3.T02_ID_TIPO_ENVIO AB18A02S00T02IDTIPOENVIO,t3.T02_DESC_ES AB18A02S00T02DESCES,t3.T02_DESC_EU AB18A02S00T02DESCEU,t3.T02_FECHA_BAJA AB18A02S00T02FECHABAJA,t4.T07_ID_TICKET AB18A07S00T07IDTICKET,t4.T07_TICKET AB18A07S00T07TICKET,t4.T07_FECHA_PETICION AB18A07S00T07FECHAPETICION,t5.T03_ID_APLICACION AB18A03S00T03IDAPLICACION,t5.T03_MODO_RECEPCION AB18A03S00T03MODORECEPCION,t5.T03_DESC_ES AB18A03S00T03DESCES,t5.T03_DESC_EU AB18A03S00T03DESCEU,t6.T11_ID_ESTADO AB18A11S00T11IDESTADO,t6.T11_DESC_ESTADO AB18A11S00T11DESCESTADO,t7.T01_ID_PETICION_ENVIO AB18A14S00T01IDPETICIONENVIO,t7.T14_ID_PUBLICACION_WS AB18A14S00T14IDPUBLICACIONWS,t7.T14_FECHA_PUBLICACION_WS AB18A14S00T14FECHAPUBLICACIONWS,t7.T14_COD_DOC_PUBLICACION_WS AB18A14S00T14CODDOCPUBLICACIONWS,t4.T03_ID_APLICACION AB18A07S00T03IDAPLICACION ");
		query.append("FROM AB18A01S00 t1 ,AB18A06S00 t2 ,AB18A02S00 t3 ,AB18A07S00 t4 ,AB18A03S00 t5 ,AB18A11S00 t6 ,AB18A14S00 t7 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab18a01s00);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.T06_ID_BOLETIN= t2.T06_ID_BOLETIN(+) AND t1.T02_ID_TIPO_ENVIO= t3.T02_ID_TIPO_ENVIO(+) AND t1.T07_ID_TICKET= t4.T07_ID_TICKET(+) AND t1.T03_ID_APLICACION= t5.T03_ID_APLICACION(+) AND t1.T11_ID_ESTADO= t6.T11_ID_ESTADO(+) AND t1.T01_ID_PETICION_ENVIO= t7.T01_ID_PETICION_ENVIO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Ab18aPeticionEnvio>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Ab18a01s00 table using like.
	 * 
	 * @param ab18a01s00
	 *            Ab18a01s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Ab18a01s00>
	 */
	@Transactional(readOnly = true)
	public List<Ab18aPeticionEnvio> findAllLike(Ab18aPeticionEnvio ab18a01s00, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.T01_ID_PETICION_ENVIO T01IDPETICIONENVIO,t1.T01_FECHA_ALTA T01FECHAALTA,t1.T01_ANUNCIO_ZIP T01ANUNCIOZIP,t1.T01_ANUNCIO_XML T01ANUNCIOXML,t1.T01_ID_PODER T01IDPODER,t1.T01_ID_ENTIDAD_IMP T01IDENTIDADIMP,t1.T01_ID_ORGANO T01IDORGANO,t1.T01_ID_ENTIDAD_TRAM T01IDENTIDADTRAM,t1.T01_ID_MESA T01IDMESA,t1.T01_FECHA_PROGR_ENVIO T01FECHAPROGRENVIO,t1.T01_NUM_INTENTOS T01NUMINTENTOS,t1.T01_DATOS_ERROR T01DATOSERROR,t1.T01_ESTADO_TRAM T01ESTADOTRAM,t1.T01_COD_EXPEDIENTE T01CODEXPEDIENTE,t1.T01_RESULT_VALID_LOGICA T01RESULTVALIDLOGICA,t1.T01_ANUNCIO_XML_CONVERTIDO T01ANUNCIOXMLCONVERTIDO,t2.T06_ID_BOLETIN AB18A06S00T06IDBOLETIN,t2.T06_DESC AB18A06S00T06DESC,t2.T06_LOGIN AB18A06S00T06LOGIN,t2.T06_PASS AB18A06S00T06PASS,t2.T06_FECHA_ULT_MODIF AB18A06S00T06FECHAULTMODIF,t3.T02_ID_TIPO_ENVIO AB18A02S00T02IDTIPOENVIO,t3.T02_DESC_ES AB18A02S00T02DESCES,t3.T02_DESC_EU AB18A02S00T02DESCEU,t3.T02_FECHA_BAJA AB18A02S00T02FECHABAJA,t4.T07_ID_TICKET AB18A07S00T07IDTICKET,t4.T07_TICKET AB18A07S00T07TICKET,t4.T07_FECHA_PETICION AB18A07S00T07FECHAPETICION,t5.T03_ID_APLICACION AB18A03S00T03IDAPLICACION,t5.T03_MODO_RECEPCION AB18A03S00T03MODORECEPCION,t5.T03_DESC_ES AB18A03S00T03DESCES,t5.T03_DESC_EU AB18A03S00T03DESCEU,t6.T11_ID_ESTADO AB18A11S00T11IDESTADO,t6.T11_DESC_ESTADO AB18A11S00T11DESCESTADO,t7.T01_ID_PETICION_ENVIO AB18A14S00T01IDPETICIONENVIO,t7.T14_ID_PUBLICACION_WS AB18A14S00T14IDPUBLICACIONWS,t7.T14_FECHA_PUBLICACION_WS AB18A14S00T14FECHAPUBLICACIONWS,t7.T14_COD_DOC_PUBLICACION_WS AB18A14S00T14CODDOCPUBLICACIONWS,t4.T03_ID_APLICACION AB18A07S00T03IDAPLICACION ");
		query.append("FROM AB18A01S00 t1 ,AB18A06S00 t2 ,AB18A02S00 t3 ,AB18A07S00 t4 ,AB18A03S00 t5 ,AB18A11S00 t6 ,AB18A14S00 t7 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab18a01s00, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.T06_ID_BOLETIN= t2.T06_ID_BOLETIN(+) AND t1.T02_ID_TIPO_ENVIO= t3.T02_ID_TIPO_ENVIO(+) AND t1.T07_ID_TICKET= t4.T07_ID_TICKET(+) AND t1.T03_ID_APLICACION= t5.T03_ID_APLICACION(+) AND t1.T11_ID_ESTADO= t6.T11_ID_ESTADO(+) AND t1.T01_ID_PETICION_ENVIO= t7.T01_ID_PETICION_ENVIO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Ab18aPeticionEnvio>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Ab18a01s00 table.
	 * 
	 * @param ab18a01s00
	 *            Ab18a01s00
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Ab18aPeticionEnvio ab18a01s00) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB18A01S00 t1 , AB18A06S00 t2 , AB18A02S00 t3 , AB18A07S00 t4 , AB18A03S00 t5 , AB18A11S00 t6 , AB18A14S00 t7 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab18a01s00);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.T06_ID_BOLETIN= t2.T06_ID_BOLETIN(+) AND t1.T02_ID_TIPO_ENVIO= t3.T02_ID_TIPO_ENVIO(+) AND t1.T07_ID_TICKET= t4.T07_ID_TICKET(+) AND t1.T03_ID_APLICACION= t5.T03_ID_APLICACION(+) AND t1.T11_ID_ESTADO= t6.T11_ID_ESTADO(+) AND t1.T01_ID_PETICION_ENVIO= t7.T01_ID_PETICION_ENVIO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Counts rows in the Ab18a01s00 table using like.
	 * 
	 * @param ab18a01s00
	 *            Ab18a01s00
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Ab18aPeticionEnvio ab18a01s00, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB18A01S00 t1 ,AB18A06S00 t2 ,AB18A02S00 t3 ,AB18A07S00 t4 ,AB18A03S00 t5 ,AB18A11S00 t6 ,AB18A14S00 t7 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab18a01s00, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.T06_ID_BOLETIN= t2.T06_ID_BOLETIN(+) AND t1.T02_ID_TIPO_ENVIO= t3.T02_ID_TIPO_ENVIO(+) AND t1.T07_ID_TICKET= t4.T07_ID_TICKET(+) AND t1.T03_ID_APLICACION= t5.T03_ID_APLICACION(+) AND t1.T11_ID_ESTADO= t6.T11_ID_ESTADO(+) AND t1.T01_ID_PETICION_ENVIO= t7.T01_ID_PETICION_ENVIO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Reorder the data list of Ab18a01s00 selected for rup_table
	 * 
	 * @param ab18a01s00
	 *            Ab18a01s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Ab18a01s00>>
	 */
	@Override
	public List<TableRowDto<Ab18aPeticionEnvio>> reorderSelection(Ab18aPeticionEnvio ab18a01s00, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.T01_ID_PETICION_ENVIO T01IDPETICIONENVIO,t1.T01_FECHA_ALTA T01FECHAALTA,t1.T01_ANUNCIO_ZIP T01ANUNCIOZIP,t1.T01_ANUNCIO_XML T01ANUNCIOXML,t1.T01_ID_PODER T01IDPODER,t1.T01_ID_ENTIDAD_IMP T01IDENTIDADIMP,t1.T01_ID_ORGANO T01IDORGANO,t1.T01_ID_ENTIDAD_TRAM T01IDENTIDADTRAM,t1.T01_ID_MESA T01IDMESA,t1.T01_FECHA_PROGR_ENVIO T01FECHAPROGRENVIO,t1.T01_NUM_INTENTOS T01NUMINTENTOS,t1.T01_DATOS_ERROR T01DATOSERROR,t1.T01_ESTADO_TRAM T01ESTADOTRAM,t1.T01_COD_EXPEDIENTE T01CODEXPEDIENTE,t1.T01_RESULT_VALID_LOGICA T01RESULTVALIDLOGICA,t1.T01_ANUNCIO_XML_CONVERTIDO T01ANUNCIOXMLCONVERTIDO,t2.T06_ID_BOLETIN AB18A06S00T06IDBOLETIN,t2.T06_DESC AB18A06S00T06DESC,t2.T06_LOGIN AB18A06S00T06LOGIN,t2.T06_PASS AB18A06S00T06PASS,t2.T06_FECHA_ULT_MODIF AB18A06S00T06FECHAULTMODIF,t3.T02_ID_TIPO_ENVIO AB18A02S00T02IDTIPOENVIO,t3.T02_DESC_ES AB18A02S00T02DESCES,t3.T02_DESC_EU AB18A02S00T02DESCEU,t3.T02_FECHA_BAJA AB18A02S00T02FECHABAJA,t4.T07_ID_TICKET AB18A07S00T07IDTICKET,t4.T07_TICKET AB18A07S00T07TICKET,t4.T07_FECHA_PETICION AB18A07S00T07FECHAPETICION,t5.T03_ID_APLICACION AB18A03S00T03IDAPLICACION,t5.T03_MODO_RECEPCION AB18A03S00T03MODORECEPCION,t5.T03_DESC_ES AB18A03S00T03DESCES,t5.T03_DESC_EU AB18A03S00T03DESCEU,t6.T11_ID_ESTADO AB18A11S00T11IDESTADO,t6.T11_DESC_ESTADO AB18A11S00T11DESCESTADO,t7.T01_ID_PETICION_ENVIO AB18A14S00T01IDPETICIONENVIO,t7.T14_ID_PUBLICACION_WS AB18A14S00T14IDPUBLICACIONWS,t7.T14_FECHA_PUBLICACION_WS AB18A14S00T14FECHAPUBLICACIONWS,t7.T14_COD_DOC_PUBLICACION_WS AB18A14S00T14CODDOCPUBLICACIONWS,t4.T03_ID_APLICACION AB18A07S00T03IDAPLICACION ");
		// FROM
		query.append("FROM AB18A01S00 t1 ,AB18A06S00 t2 ,AB18A02S00 t3 ,AB18A07S00 t4 ,AB18A03S00 t5 ,AB18A11S00 t6 ,AB18A14S00 t7 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab18a01s00, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.T06_ID_BOLETIN= t2.T06_ID_BOLETIN(+) AND t1.T02_ID_TIPO_ENVIO= t3.T02_ID_TIPO_ENVIO(+) AND t1.T07_ID_TICKET= t4.T07_ID_TICKET(+) AND t1.T03_ID_APLICACION= t5.T03_ID_APLICACION(+) AND t1.T11_ID_ESTADO= t6.T11_ID_ESTADO(+) AND t1.T01_ID_PETICION_ENVIO= t7.T01_ID_PETICION_ENVIO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(query, jqGridRequestDto, Ab18aPeticionEnvio.class, filterParamList,
				"T01_ID_PETICION_ENVIO");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(), new RowNumResultSetExtractor<Ab18aPeticionEnvio>(this.rwMapPK,
				jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
	 * 
	 * @param filterParams
	 *            Ab18a01s00
	 * @param searchParams
	 *            Ab18a01s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Ab18a01s00>>
	 */
	@Override
	public List<TableRowDto<Ab18aPeticionEnvio>> search(Ab18aPeticionEnvio filterParams, Ab18aPeticionEnvio searchParams,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.T01_ID_PETICION_ENVIO T01IDPETICIONENVIO,t1.T01_FECHA_ALTA T01FECHAALTA,t1.T01_ANUNCIO_ZIP T01ANUNCIOZIP,t1.T01_ANUNCIO_XML T01ANUNCIOXML,t1.T01_ID_PODER T01IDPODER,t1.T01_ID_ENTIDAD_IMP T01IDENTIDADIMP,t1.T01_ID_ORGANO T01IDORGANO,t1.T01_ID_ENTIDAD_TRAM T01IDENTIDADTRAM,t1.T01_ID_MESA T01IDMESA,t1.T01_FECHA_PROGR_ENVIO T01FECHAPROGRENVIO,t1.T01_NUM_INTENTOS T01NUMINTENTOS,t1.T01_DATOS_ERROR T01DATOSERROR,t1.T01_ESTADO_TRAM T01ESTADOTRAM,t1.T01_COD_EXPEDIENTE T01CODEXPEDIENTE,t1.T01_RESULT_VALID_LOGICA T01RESULTVALIDLOGICA,t1.T01_ANUNCIO_XML_CONVERTIDO T01ANUNCIOXMLCONVERTIDO,t2.T06_ID_BOLETIN AB18A06S00T06IDBOLETIN,t2.T06_DESC AB18A06S00T06DESC,t2.T06_LOGIN AB18A06S00T06LOGIN,t2.T06_PASS AB18A06S00T06PASS,t2.T06_FECHA_ULT_MODIF AB18A06S00T06FECHAULTMODIF,t3.T02_ID_TIPO_ENVIO AB18A02S00T02IDTIPOENVIO,t3.T02_DESC_ES AB18A02S00T02DESCES,t3.T02_DESC_EU AB18A02S00T02DESCEU,t3.T02_FECHA_BAJA AB18A02S00T02FECHABAJA,t4.T07_ID_TICKET AB18A07S00T07IDTICKET,t4.T07_TICKET AB18A07S00T07TICKET,t4.T07_FECHA_PETICION AB18A07S00T07FECHAPETICION,t5.T03_ID_APLICACION AB18A03S00T03IDAPLICACION,t5.T03_MODO_RECEPCION AB18A03S00T03MODORECEPCION,t5.T03_DESC_ES AB18A03S00T03DESCES,t5.T03_DESC_EU AB18A03S00T03DESCEU,t6.T11_ID_ESTADO AB18A11S00T11IDESTADO,t6.T11_DESC_ESTADO AB18A11S00T11DESCESTADO,t7.T01_ID_PETICION_ENVIO AB18A14S00T01IDPETICIONENVIO,t7.T14_ID_PUBLICACION_WS AB18A14S00T14IDPUBLICACIONWS,t7.T14_FECHA_PUBLICACION_WS AB18A14S00T14FECHAPUBLICACIONWS,t7.T14_COD_DOC_PUBLICACION_WS AB18A14S00T14CODDOCPUBLICACIONWS,t4.T03_ID_APLICACION AB18A07S00T03IDAPLICACION ");
		// FROM
		query.append("FROM AB18A01S00 t1 ,AB18A06S00 t2 ,AB18A02S00 t3 ,AB18A07S00 t4 ,AB18A03S00 t5 ,AB18A11S00 t6 ,AB18A14S00 t7 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");
		from_alias.add(" t3 ");
		from_alias.add(" t4 ");
		from_alias.add(" t5 ");
		from_alias.add(" t6 ");
		from_alias.add(" t7 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.T06_ID_BOLETIN= t2.T06_ID_BOLETIN(+) AND t1.T02_ID_TIPO_ENVIO= t3.T02_ID_TIPO_ENVIO(+) AND t1.T07_ID_TICKET= t4.T07_ID_TICKET(+) AND t1.T03_ID_APLICACION= t5.T03_ID_APLICACION(+) AND t1.T11_ID_ESTADO= t6.T11_ID_ESTADO(+) AND t1.T01_ID_PETICION_ENVIO= t7.T01_ID_PETICION_ENVIO(+) ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query")).toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(query, jqGridRequestDto, Ab18aPeticionEnvio.class, filterParamList,
				searchSQL, searchParamList, from_alias, "T01_ID_PETICION_ENVIO");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(), new RowNumResultSetExtractor<Ab18aPeticionEnvio>(this.rwMapPK,
				jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table
	 * 
	 * @param filterab18a01s00
	 *            Ab18a01s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	@Override
	public void removeMultiple(Ab18aPeticionEnvio filterab18a01s00, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.T01_ID_PETICION_ENVIO T01IDPETICIONENVIO,t1.T01_FECHA_ALTA T01FECHAALTA,t1.T01_ANUNCIO_ZIP T01ANUNCIOZIP,t1.T01_ANUNCIO_XML T01ANUNCIOXML,t1.T01_ID_PODER T01IDPODER,t1.T01_ID_ENTIDAD_IMP T01IDENTIDADIMP,t1.T01_ID_ORGANO T01IDORGANO,t1.T01_ID_ENTIDAD_TRAM T01IDENTIDADTRAM,t1.T01_ID_MESA T01IDMESA,t1.T01_FECHA_PROGR_ENVIO T01FECHAPROGRENVIO,t1.T01_NUM_INTENTOS T01NUMINTENTOS,t1.T01_DATOS_ERROR T01DATOSERROR,t1.T01_ESTADO_TRAM T01ESTADOTRAM,t1.T01_COD_EXPEDIENTE T01CODEXPEDIENTE,t1.T01_RESULT_VALID_LOGICA T01RESULTVALIDLOGICA,t1.T01_ANUNCIO_XML_CONVERTIDO T01ANUNCIOXMLCONVERTIDO,t2.T06_ID_BOLETIN AB18A06S00T06IDBOLETIN,t2.T06_DESC AB18A06S00T06DESC,t2.T06_LOGIN AB18A06S00T06LOGIN,t2.T06_PASS AB18A06S00T06PASS,t2.T06_FECHA_ULT_MODIF AB18A06S00T06FECHAULTMODIF,t3.T02_ID_TIPO_ENVIO AB18A02S00T02IDTIPOENVIO,t3.T02_DESC_ES AB18A02S00T02DESCES,t3.T02_DESC_EU AB18A02S00T02DESCEU,t3.T02_FECHA_BAJA AB18A02S00T02FECHABAJA,t4.T07_ID_TICKET AB18A07S00T07IDTICKET,t4.T07_TICKET AB18A07S00T07TICKET,t4.T07_FECHA_PETICION AB18A07S00T07FECHAPETICION,t5.T03_ID_APLICACION AB18A03S00T03IDAPLICACION,t5.T03_MODO_RECEPCION AB18A03S00T03MODORECEPCION,t5.T03_DESC_ES AB18A03S00T03DESCES,t5.T03_DESC_EU AB18A03S00T03DESCEU,t6.T11_ID_ESTADO AB18A11S00T11IDESTADO,t6.T11_DESC_ESTADO AB18A11S00T11DESCESTADO,t7.T01_ID_PETICION_ENVIO AB18A14S00T01IDPETICIONENVIO,t7.T14_ID_PUBLICACION_WS AB18A14S00T14IDPUBLICACIONWS,t7.T14_FECHA_PUBLICACION_WS AB18A14S00T14FECHAPUBLICACIONWS,t7.T14_COD_DOC_PUBLICACION_WS AB18A14S00T14CODDOCPUBLICACIONWS,t4.T03_ID_APLICACION AB18A07S00T03IDAPLICACION ");
		// FROM
		query.append("FROM AB18A01S00 t1 ,AB18A06S00 t2 ,AB18A02S00 t3 ,AB18A07S00 t4 ,AB18A03S00 t5 ,AB18A11S00 t6 ,AB18A14S00 t7 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filterab18a01s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager.getRemoveMultipleQuery(jqGridRequestDto, Ab18aPeticionEnvio.class, query, params,
				"T01_ID_PETICION_ENVIO");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(), params.toArray());
	}

	/**
	 * Filter in the hierarchical Ab18a01s00 table.
	 * 
	 * @param filterAb18a01s00
	 *            Ab18a01s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<JerarquiaDto<Ab18a01s00>>
	 */
	@Override
	public List<JerarquiaDto<Ab18aPeticionEnvio>> findAllLikeJerarquia(Ab18aPeticionEnvio filterAb18a01s00, JQGridRequestDto jqGridRequestDto) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.T01_ID_PETICION_ENVIO T01IDPETICIONENVIO,t1.T01_FECHA_ALTA T01FECHAALTA,t1.T01_ANUNCIO_ZIP T01ANUNCIOZIP,t1.T01_ANUNCIO_XML T01ANUNCIOXML,t1.T01_ID_PODER T01IDPODER,t1.T01_ID_ENTIDAD_IMP T01IDENTIDADIMP,t1.T01_ID_ORGANO T01IDORGANO,t1.T01_ID_ENTIDAD_TRAM T01IDENTIDADTRAM,t1.T01_ID_MESA T01IDMESA,t1.T01_FECHA_PROGR_ENVIO T01FECHAPROGRENVIO,t1.T01_NUM_INTENTOS T01NUMINTENTOS,t1.T01_DATOS_ERROR T01DATOSERROR,t1.T01_ESTADO_TRAM T01ESTADOTRAM,t1.T01_COD_EXPEDIENTE T01CODEXPEDIENTE,t1.T01_RESULT_VALID_LOGICA T01RESULTVALIDLOGICA,t1.T01_ANUNCIO_XML_CONVERTIDO T01ANUNCIOXMLCONVERTIDO,t2.T06_ID_BOLETIN AB18A06S00T06IDBOLETIN,t2.T06_DESC AB18A06S00T06DESC,t2.T06_LOGIN AB18A06S00T06LOGIN,t2.T06_PASS AB18A06S00T06PASS,t2.T06_FECHA_ULT_MODIF AB18A06S00T06FECHAULTMODIF,t3.T02_ID_TIPO_ENVIO AB18A02S00T02IDTIPOENVIO,t3.T02_DESC_ES AB18A02S00T02DESCES,t3.T02_DESC_EU AB18A02S00T02DESCEU,t3.T02_FECHA_BAJA AB18A02S00T02FECHABAJA,t4.T07_ID_TICKET AB18A07S00T07IDTICKET,t4.T07_TICKET AB18A07S00T07TICKET,t4.T07_FECHA_PETICION AB18A07S00T07FECHAPETICION,t5.T03_ID_APLICACION AB18A03S00T03IDAPLICACION,t5.T03_MODO_RECEPCION AB18A03S00T03MODORECEPCION,t5.T03_DESC_ES AB18A03S00T03DESCES,t5.T03_DESC_EU AB18A03S00T03DESCEU,t6.T11_ID_ESTADO AB18A11S00T11IDESTADO,t6.T11_DESC_ESTADO AB18A11S00T11DESCESTADO,t7.T01_ID_PETICION_ENVIO AB18A14S00T01IDPETICIONENVIO,t7.T14_ID_PUBLICACION_WS AB18A14S00T14IDPUBLICACIONWS,t7.T14_FECHA_PUBLICACION_WS AB18A14S00T14FECHAPUBLICACIONWS,t7.T14_COD_DOC_PUBLICACION_WS AB18A14S00T14CODDOCPUBLICACIONWS,t4.T03_ID_APLICACION AB18A07S00T03IDAPLICACION ");
		// FROM
		// StringBuilder from = new
		// StringBuilder("FROM AB18A01S00 t1 ,AB18A06S00 t2 ,AB18A02S00 t3 ,AB18A07S00 t4 ,AB18A03S00 t5 ,AB18A11S00 t6 ,AB18A14S00 t7 ");
		List<String> from = new ArrayList<String>();
		from.add("AB18A01S00");
		from.add("AB18A06S00");
		from.add("AB18A02S00");
		from.add("AB18A07S00");
		from.add("AB18A03S00");
		from.add("AB18A11S00");
		from.add("AB18A14S00");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");
		from_alias.add(" t3 ");
		from_alias.add(" t4 ");
		from_alias.add(" t5 ");
		from_alias.add(" t6 ");
		from_alias.add(" t7 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.XXXX = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAb18a01s00, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query, mapaWhere, "T01_ID_PETICION_ENVIO", "ID_PADRE", "NOMBRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto, query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia, params.toArray());
	}

	/**
	 * Count rows in hierarchy
	 * 
	 * @param filterAb18a01s00
	 *            Ab18a01s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return Long
	 */
	@Override
	public Long findAllLikeCountJerarquia(Ab18aPeticionEnvio filterAb18a01s00, JQGridRequestDto jqGridRequestDto) {
		// FROM
		// StringBuilder from = new
		// StringBuilder("FROM AB18A01S00 t1 ,AB18A06S00 t2 ,AB18A02S00 t3 ,AB18A07S00 t4 ,AB18A03S00 t5 ,AB18A11S00 t6 ,AB18A14S00 t7 ");
		List<String> from = new ArrayList<String>();
		from.add("AB18A01S00");
		from.add("AB18A06S00");
		from.add("AB18A02S00");
		from.add("AB18A07S00");
		from.add("AB18A03S00");
		from.add("AB18A11S00");
		from.add("AB18A14S00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");
		from_alias.add(" t3 ");
		from_alias.add(" t4 ");
		from_alias.add(" t5 ");
		from_alias.add(" t6 ");
		from_alias.add(" t7 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.XXXX = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAb18a01s00, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia
				.getQueryCount(jqGridRequestDto, mapaWhere, "T01_ID_PETICION_ENVIO", "ID_PADRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Find dependent hierarchical rows
	 * 
	 * @param filterAb18a01s00
	 *            Ab18a01s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<TableRowDto<Ab18a01s00>>
	 */
	@Override
	public List<TableRowDto<Ab18aPeticionEnvio>> findAllChild(Ab18aPeticionEnvio filterAb18a01s00, JQGridRequestDto jqGridRequestDto) {

		// FROM
		// StringBuilder from = new
		// StringBuilder("FROM AB18A01S00 t1 ,AB18A06S00 t2 ,AB18A02S00 t3 ,AB18A07S00 t4 ,AB18A03S00 t5 ,AB18A11S00 t6 ,AB18A14S00 t7 ");
		List<String> from = new ArrayList<String>();
		from.add("AB18A01S00");
		from.add("AB18A06S00");
		from.add("AB18A02S00");
		from.add("AB18A07S00");
		from.add("AB18A03S00");
		from.add("AB18A11S00");
		from.add("AB18A14S00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");
		from_alias.add(" t3 ");
		from_alias.add(" t4 ");
		from_alias.add(" t5 ");
		from_alias.add(" t6 ");
		from_alias.add(" t7 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.XXXX = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAb18a01s00, false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere, "T01_ID_PETICION_ENVIO", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.query(query.toString(), new RowNumResultSetExtractor<Ab18aPeticionEnvio>(this.rwMapPK, "T01_ID_PETICION_ENVIO"),
				params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab18a01s00 entity
	 * 
	 * @param ab18a01s00
	 *            Ab18a01s00 Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de XXXX
	private Map<String, ?> getWhereMap(Ab18aPeticionEnvio ab18a01s00) {

		StringBuilder where = new StringBuilder(Ab18aPeticionEnvioDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		// if (ab18a01s00 != null && ab18a01s00.getT01IdPeticionEnvio() != null)
		// {
		// where.append(" AND t1.T01_ID_PETICION_ENVIO = ?");
		// params.add(ab18a01s00.getT01IdPeticionEnvio());
		// }
		// if (ab18a01s00 != null && ab18a01s00.getAb18a06s00() != null
		// && ab18a01s00.getAb18a06s00().getT06IdBoletin() != null) {
		// where.append(" AND t2.T06_ID_BOLETIN = ?");
		// params.add(ab18a01s00.getAb18a06s00().getT06IdBoletin());
		// }
		// if (ab18a01s00 != null && ab18a01s00.getAb18a06s00() != null
		// && ab18a01s00.getAb18a06s00().getT06Desc() != null) {
		// where.append(" AND t2.T06_DESC = ?");
		// params.add(ab18a01s00.getAb18a06s00().getT06Desc());
		// }
		// if (ab18a01s00 != null && ab18a01s00.getAb18a06s00() != null
		// && ab18a01s00.getAb18a06s00().getT06Login() != null) {
		// where.append(" AND t2.T06_LOGIN = ?");
		// params.add(ab18a01s00.getAb18a06s00().getT06Login());
		// }
		// if (ab18a01s00 != null && ab18a01s00.getAb18a06s00() != null
		// && ab18a01s00.getAb18a06s00().getT06Pass() != null) {
		// where.append(" AND t2.T06_PASS = ?");
		// params.add(ab18a01s00.getAb18a06s00().getT06Pass());
		// }
		// if (ab18a01s00 != null && ab18a01s00.getAb18a06s00() != null
		// && ab18a01s00.getAb18a06s00().getT06FechaUltModif() != null) {
		// where.append(" AND t2.T06_FECHA_ULT_MODIF = ?");
		// params.add(ab18a01s00.getAb18a06s00().getT06FechaUltModif());
		// }
		// if (ab18a01s00 != null && ab18a01s00.getAb18a02s00() != null
		// && ab18a01s00.getAb18a02s00().getT02IdTipoEnvio() != null) {
		// where.append(" AND t3.T02_ID_TIPO_ENVIO = ?");
		// params.add(ab18a01s00.getAb18a02s00().getT02IdTipoEnvio());
		// }
		// if (ab18a01s00 != null && ab18a01s00.getAb18a02s00() != null
		// && ab18a01s00.getAb18a02s00().getT02DescEs() != null) {
		// where.append(" AND t3.T02_DESC_ES = ?");
		// params.add(ab18a01s00.getAb18a02s00().getT02DescEs());
		// }
		// if (ab18a01s00 != null && ab18a01s00.getAb18a02s00() != null
		// && ab18a01s00.getAb18a02s00().getT02DescEu() != null) {
		// where.append(" AND t3.T02_DESC_EU = ?");
		// params.add(ab18a01s00.getAb18a02s00().getT02DescEu());
		// }
		// if (ab18a01s00 != null && ab18a01s00.getAb18a02s00() != null
		// && ab18a01s00.getAb18a02s00().getT02FechaBaja() != null) {
		// where.append(" AND t3.T02_FECHA_BAJA = ?");
		// params.add(ab18a01s00.getAb18a02s00().getT02FechaBaja());
		// }
		// if (ab18a01s00 != null && ab18a01s00.getAb18a07s00() != null
		// && ab18a01s00.getAb18a07s00().getT07IdTicket() != null) {
		// where.append(" AND t4.T07_ID_TICKET = ?");
		// params.add(ab18a01s00.getAb18a07s00().getT07IdTicket());
		// }
		// if (ab18a01s00 != null
		// && ab18a01s00.getAb18a07s00() != null
		// && ab18a01s00.getAb18a07s00().getAb18a03s00() != null
		// && ab18a01s00.getAb18a07s00().getAb18a03s00()
		// .getT03IdAplicacion() != null) {
		// where.append(" AND t4.T03_ID_APLICACION = ?");
		// params.add(ab18a01s00.getAb18a07s00().getAb18a03s00()
		// .getT03IdAplicacion());
		// }
		// if (ab18a01s00 != null && ab18a01s00.getAb18a07s00() != null
		// && ab18a01s00.getAb18a07s00().getT07Ticket() != null) {
		// where.append(" AND t4.T07_TICKET = ?");
		// params.add(ab18a01s00.getAb18a07s00().getT07Ticket());
		// }
		// if (ab18a01s00 != null && ab18a01s00.getAb18a07s00() != null
		// && ab18a01s00.getAb18a07s00().getT07FechaPeticion() != null) {
		// where.append(" AND t4.T07_FECHA_PETICION = ?");
		// params.add(ab18a01s00.getAb18a07s00().getT07FechaPeticion());
		// }
		// if (ab18a01s00 != null && ab18a01s00.getAb18a03s00() != null
		// && ab18a01s00.getAb18a03s00().getT03IdAplicacion() != null) {
		// where.append(" AND t5.T03_ID_APLICACION = ?");
		// params.add(ab18a01s00.getAb18a03s00().getT03IdAplicacion());
		// }
		// if (ab18a01s00 != null && ab18a01s00.getAb18a03s00() != null
		// && ab18a01s00.getAb18a03s00().getT03ModoRecepcion() != null) {
		// where.append(" AND t5.T03_MODO_RECEPCION = ?");
		// params.add(ab18a01s00.getAb18a03s00().getT03ModoRecepcion());
		// }
		// if (ab18a01s00 != null && ab18a01s00.getAb18a03s00() != null
		// && ab18a01s00.getAb18a03s00().getT03DescEs() != null) {
		// where.append(" AND t5.T03_DESC_ES = ?");
		// params.add(ab18a01s00.getAb18a03s00().getT03DescEs());
		// }
		// if (ab18a01s00 != null && ab18a01s00.getAb18a03s00() != null
		// && ab18a01s00.getAb18a03s00().getT03DescEu() != null) {
		// where.append(" AND t5.T03_DESC_EU = ?");
		// params.add(ab18a01s00.getAb18a03s00().getT03DescEu());
		// }
		// if (ab18a01s00 != null && ab18a01s00.getAb18a11s00() != null
		// && ab18a01s00.getAb18a11s00().getT11IdEstado() != null) {
		// where.append(" AND t6.T11_ID_ESTADO = ?");
		// params.add(ab18a01s00.getAb18a11s00().getT11IdEstado());
		// }
		// if (ab18a01s00 != null && ab18a01s00.getAb18a11s00() != null
		// && ab18a01s00.getAb18a11s00().getT11DescEstado() != null) {
		// where.append(" AND t6.T11_DESC_ESTADO = ?");
		// params.add(ab18a01s00.getAb18a11s00().getT11DescEstado());
		// }
		// if (ab18a01s00 != null && ab18a01s00.getT01FechaAlta() != null) {
		// where.append(" AND t1.T01_FECHA_ALTA = ?");
		// params.add(ab18a01s00.getT01FechaAlta());
		// }
		// if (ab18a01s00 != null && ab18a01s00.getT01IdPoder() != null) {
		// where.append(" AND t1.T01_ID_PODER = ?");
		// params.add(ab18a01s00.getT01IdPoder());
		// }
		// if (ab18a01s00 != null && ab18a01s00.getT01IdEntidadImp() != null) {
		// where.append(" AND t1.T01_ID_ENTIDAD_IMP = ?");
		// params.add(ab18a01s00.getT01IdEntidadImp());
		// }
		// if (ab18a01s00 != null && ab18a01s00.getT01IdOrgano() != null) {
		// where.append(" AND t1.T01_ID_ORGANO = ?");
		// params.add(ab18a01s00.getT01IdOrgano());
		// }
		// if (ab18a01s00 != null && ab18a01s00.getT01IdEntidadTram() != null) {
		// where.append(" AND t1.T01_ID_ENTIDAD_TRAM = ?");
		// params.add(ab18a01s00.getT01IdEntidadTram());
		// }
		// if (ab18a01s00 != null && ab18a01s00.getT01IdMesa() != null) {
		// where.append(" AND t1.T01_ID_MESA = ?");
		// params.add(ab18a01s00.getT01IdMesa());
		// }
		// if (ab18a01s00 != null && ab18a01s00.getT01FechaProgrEnvio() != null)
		// {
		// where.append(" AND t1.T01_FECHA_PROGR_ENVIO = ?");
		// params.add(ab18a01s00.getT01FechaProgrEnvio());
		// }
		// if (ab18a01s00 != null && ab18a01s00.getT01NumIntentos() != null) {
		// where.append(" AND t1.T01_NUM_INTENTOS = ?");
		// params.add(ab18a01s00.getT01NumIntentos());
		// }
		// if (ab18a01s00 != null && ab18a01s00.getT01DatosError() != null) {
		// where.append(" AND t1.T01_DATOS_ERROR = ?");
		// params.add(ab18a01s00.getT01DatosError());
		// }
		// if (ab18a01s00 != null && ab18a01s00.getT01EstadoTram() != null) {
		// where.append(" AND t1.T01_ESTADO_TRAM = ?");
		// params.add(ab18a01s00.getT01EstadoTram());
		// }
		// if (ab18a01s00 != null && ab18a01s00.getT01CodExpediente() != null) {
		// where.append(" AND t1.T01_COD_EXPEDIENTE = ?");
		// params.add(ab18a01s00.getT01CodExpediente());
		// }
		// if (ab18a01s00 != null && ab18a01s00.getAb18a14s00() != null
		// && ab18a01s00.getAb18a14s00().getT01IdPeticionEnvio() != null) {
		// where.append(" AND t7.T01_ID_PETICION_ENVIO = ?");
		// params.add(ab18a01s00.getAb18a14s00().getT01IdPeticionEnvio());
		// }
		// if (ab18a01s00 != null && ab18a01s00.getAb18a14s00() != null
		// && ab18a01s00.getAb18a14s00().getT14IdPublicacionWs() != null) {
		// where.append(" AND t7.T14_ID_PUBLICACION_WS = ?");
		// params.add(ab18a01s00.getAb18a14s00().getT14IdPublicacionWs());
		// }
		// if (ab18a01s00 != null
		// && ab18a01s00.getAb18a14s00() != null
		// && ab18a01s00.getAb18a14s00().getT14FechaPublicacionWs() != null) {
		// where.append(" AND t7.T14_FECHA_PUBLICACION_WS = ?");
		// params.add(ab18a01s00.getAb18a14s00().getT14FechaPublicacionWs());
		// }
		// if (ab18a01s00 != null
		// && ab18a01s00.getAb18a14s00() != null
		// && ab18a01s00.getAb18a14s00().getT14CodDocPublicacionWs() != null) {
		// where.append(" AND t7.T14_COD_DOC_PUBLICACION_WS = ?");
		// params.add(ab18a01s00.getAb18a14s00().getT14CodDocPublicacionWs());
		// }

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de XXXX

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab18a01s00 entity
	 * 
	 * @param ab18a01s00
	 *            Ab18a01s00 Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de XXXX
	private Map<String, Object> getWhereLikeMap(Ab18aPeticionEnvio ab18a01s00, Boolean startsWith) {

		StringBuilder where = new StringBuilder(Ab18aPeticionEnvioDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		// if (ab18a01s00 != null && ab18a01s00.getT01IdPeticionEnvio() != null)
		// {
		// where.append(" AND t1.T01_ID_PETICION_ENVIO = ?");
		// params.add(ab18a01s00.getT01IdPeticionEnvio());
		// }
		// if (ab18a01s00 != null && ab18a01s00.getAb18a06s00() != null
		// && ab18a01s00.getAb18a06s00().getT06IdBoletin() != null) {
		// where.append(" AND t2.T06_ID_BOLETIN = ?");
		// params.add(ab18a01s00.getAb18a06s00().getT06IdBoletin());
		// }
		// if (ab18a01s00 != null && ab18a01s00.getAb18a06s00() != null
		// && ab18a01s00.getAb18a06s00().getT06Desc() != null) {
		// where.append(" AND UPPER(t2.T06_DESC) like ? ESCAPE  '\\'");
		// if (startsWith) {
		// params.add(ab18a01s00.getAb18a06s00().getT06Desc()
		// .toUpperCase()
		// + "%");
		// } else {
		// params.add("%"
		// + ab18a01s00.getAb18a06s00().getT06Desc().toUpperCase()
		// + "%");
		// }
		// where.append(" AND t2.T06_DESC IS NOT NULL");
		// }
		// if (ab18a01s00 != null && ab18a01s00.getAb18a06s00() != null
		// && ab18a01s00.getAb18a06s00().getT06Login() != null) {
		// where.append(" AND UPPER(t2.T06_LOGIN) like ? ESCAPE  '\\'");
		// if (startsWith) {
		// params.add(ab18a01s00.getAb18a06s00().getT06Login()
		// .toUpperCase()
		// + "%");
		// } else {
		// params.add("%"
		// + ab18a01s00.getAb18a06s00().getT06Login()
		// .toUpperCase() + "%");
		// }
		// where.append(" AND t2.T06_LOGIN IS NOT NULL");
		// }
		// if (ab18a01s00 != null && ab18a01s00.getAb18a06s00() != null
		// && ab18a01s00.getAb18a06s00().getT06Pass() != null) {
		// where.append(" AND UPPER(t2.T06_PASS) like ? ESCAPE  '\\'");
		// if (startsWith) {
		// params.add(ab18a01s00.getAb18a06s00().getT06Pass()
		// .toUpperCase()
		// + "%");
		// } else {
		// params.add("%"
		// + ab18a01s00.getAb18a06s00().getT06Pass().toUpperCase()
		// + "%");
		// }
		// where.append(" AND t2.T06_PASS IS NOT NULL");
		// }
		// if (ab18a01s00 != null && ab18a01s00.getAb18a06s00() != null
		// && ab18a01s00.getAb18a06s00().getT06FechaUltModif() != null) {
		// where.append(" AND t2.T06_FECHA_ULT_MODIF = ?");
		// params.add(ab18a01s00.getAb18a06s00().getT06FechaUltModif());
		// }
		// if (ab18a01s00 != null && ab18a01s00.getAb18a02s00() != null
		// && ab18a01s00.getAb18a02s00().getT02IdTipoEnvio() != null) {
		// where.append(" AND t3.T02_ID_TIPO_ENVIO = ?");
		// params.add(ab18a01s00.getAb18a02s00().getT02IdTipoEnvio());
		// }
		// if (ab18a01s00 != null && ab18a01s00.getAb18a02s00() != null
		// && ab18a01s00.getAb18a02s00().getT02DescEs() != null) {
		// where.append(" AND UPPER(t3.T02_DESC_ES) like ? ESCAPE  '\\'");
		// if (startsWith) {
		// params.add(ab18a01s00.getAb18a02s00().getT02DescEs()
		// .toUpperCase()
		// + "%");
		// } else {
		// params.add("%"
		// + ab18a01s00.getAb18a02s00().getT02DescEs()
		// .toUpperCase() + "%");
		// }
		// where.append(" AND t3.T02_DESC_ES IS NOT NULL");
		// }
		// if (ab18a01s00 != null && ab18a01s00.getAb18a02s00() != null
		// && ab18a01s00.getAb18a02s00().getT02DescEu() != null) {
		// where.append(" AND UPPER(t3.T02_DESC_EU) like ? ESCAPE  '\\'");
		// if (startsWith) {
		// params.add(ab18a01s00.getAb18a02s00().getT02DescEu()
		// .toUpperCase()
		// + "%");
		// } else {
		// params.add("%"
		// + ab18a01s00.getAb18a02s00().getT02DescEu()
		// .toUpperCase() + "%");
		// }
		// where.append(" AND t3.T02_DESC_EU IS NOT NULL");
		// }
		// if (ab18a01s00 != null && ab18a01s00.getAb18a02s00() != null
		// && ab18a01s00.getAb18a02s00().getT02FechaBaja() != null) {
		// where.append(" AND t3.T02_FECHA_BAJA = ?");
		// params.add(ab18a01s00.getAb18a02s00().getT02FechaBaja());
		// }
		// if (ab18a01s00 != null && ab18a01s00.getAb18a07s00() != null
		// && ab18a01s00.getAb18a07s00().getT07IdTicket() != null) {
		// where.append(" AND t4.T07_ID_TICKET = ?");
		// params.add(ab18a01s00.getAb18a07s00().getT07IdTicket());
		// }
		// if (ab18a01s00 != null
		// && ab18a01s00.getAb18a07s00() != null
		// && ab18a01s00.getAb18a07s00().getAb18a03s00() != null
		// && ab18a01s00.getAb18a07s00().getAb18a03s00()
		// .getT03IdAplicacion() != null) {
		// where.append(" AND t4.T03_ID_APLICACION = ?");
		// params.add(ab18a01s00.getAb18a07s00().getAb18a03s00()
		// .getT03IdAplicacion());
		// }
		// if (ab18a01s00 != null && ab18a01s00.getAb18a07s00() != null
		// && ab18a01s00.getAb18a07s00().getT07Ticket() != null) {
		// where.append(" AND UPPER(t4.T07_TICKET) like ? ESCAPE  '\\'");
		// if (startsWith) {
		// params.add(ab18a01s00.getAb18a07s00().getT07Ticket()
		// .toUpperCase()
		// + "%");
		// } else {
		// params.add("%"
		// + ab18a01s00.getAb18a07s00().getT07Ticket()
		// .toUpperCase() + "%");
		// }
		// where.append(" AND t4.T07_TICKET IS NOT NULL");
		// }
		// if (ab18a01s00 != null && ab18a01s00.getAb18a07s00() != null
		// && ab18a01s00.getAb18a07s00().getT07FechaPeticion() != null) {
		// where.append(" AND t4.T07_FECHA_PETICION = ?");
		// params.add(ab18a01s00.getAb18a07s00().getT07FechaPeticion());
		// }
		// if (ab18a01s00 != null && ab18a01s00.getAb18a03s00() != null
		// && ab18a01s00.getAb18a03s00().getT03IdAplicacion() != null) {
		// where.append(" AND t5.T03_ID_APLICACION = ?");
		// params.add(ab18a01s00.getAb18a03s00().getT03IdAplicacion());
		// }
		// if (ab18a01s00 != null && ab18a01s00.getAb18a03s00() != null
		// && ab18a01s00.getAb18a03s00().getT03ModoRecepcion() != null) {
		// where.append(" AND t5.T03_MODO_RECEPCION = ?");
		// params.add(ab18a01s00.getAb18a03s00().getT03ModoRecepcion());
		// }
		// if (ab18a01s00 != null && ab18a01s00.getAb18a03s00() != null
		// && ab18a01s00.getAb18a03s00().getT03DescEs() != null) {
		// where.append(" AND UPPER(t5.T03_DESC_ES) like ? ESCAPE  '\\'");
		// if (startsWith) {
		// params.add(ab18a01s00.getAb18a03s00().getT03DescEs()
		// .toUpperCase()
		// + "%");
		// } else {
		// params.add("%"
		// + ab18a01s00.getAb18a03s00().getT03DescEs()
		// .toUpperCase() + "%");
		// }
		// where.append(" AND t5.T03_DESC_ES IS NOT NULL");
		// }
		// if (ab18a01s00 != null && ab18a01s00.getAb18a03s00() != null
		// && ab18a01s00.getAb18a03s00().getT03DescEu() != null) {
		// where.append(" AND UPPER(t5.T03_DESC_EU) like ? ESCAPE  '\\'");
		// if (startsWith) {
		// params.add(ab18a01s00.getAb18a03s00().getT03DescEu()
		// .toUpperCase()
		// + "%");
		// } else {
		// params.add("%"
		// + ab18a01s00.getAb18a03s00().getT03DescEu()
		// .toUpperCase() + "%");
		// }
		// where.append(" AND t5.T03_DESC_EU IS NOT NULL");
		// }
		// if (ab18a01s00 != null && ab18a01s00.getAb18a11s00() != null
		// && ab18a01s00.getAb18a11s00().getT11IdEstado() != null) {
		// where.append(" AND t6.T11_ID_ESTADO = ?");
		// params.add(ab18a01s00.getAb18a11s00().getT11IdEstado());
		// }
		// if (ab18a01s00 != null && ab18a01s00.getAb18a11s00() != null
		// && ab18a01s00.getAb18a11s00().getT11DescEstado() != null) {
		// where.append(" AND UPPER(t6.T11_DESC_ESTADO) like ? ESCAPE  '\\'");
		// if (startsWith) {
		// params.add(ab18a01s00.getAb18a11s00().getT11DescEstado()
		// .toUpperCase()
		// + "%");
		// } else {
		// params.add("%"
		// + ab18a01s00.getAb18a11s00().getT11DescEstado()
		// .toUpperCase() + "%");
		// }
		// where.append(" AND t6.T11_DESC_ESTADO IS NOT NULL");
		// }
		// if (ab18a01s00 != null && ab18a01s00.getT01FechaAlta() != null) {
		// where.append(" AND t1.T01_FECHA_ALTA = ?");
		// params.add(ab18a01s00.getT01FechaAlta());
		// }
		// if (ab18a01s00 != null && ab18a01s00.getT01IdPoder() != null) {
		// where.append(" AND t1.T01_ID_PODER = ?");
		// params.add(ab18a01s00.getT01IdPoder());
		// }
		// if (ab18a01s00 != null && ab18a01s00.getT01IdEntidadImp() != null) {
		// where.append(" AND t1.T01_ID_ENTIDAD_IMP = ?");
		// params.add(ab18a01s00.getT01IdEntidadImp());
		// }
		// if (ab18a01s00 != null && ab18a01s00.getT01IdOrgano() != null) {
		// where.append(" AND t1.T01_ID_ORGANO = ?");
		// params.add(ab18a01s00.getT01IdOrgano());
		// }
		// if (ab18a01s00 != null && ab18a01s00.getT01IdEntidadTram() != null) {
		// where.append(" AND t1.T01_ID_ENTIDAD_TRAM = ?");
		// params.add(ab18a01s00.getT01IdEntidadTram());
		// }
		// if (ab18a01s00 != null && ab18a01s00.getT01IdMesa() != null) {
		// where.append(" AND t1.T01_ID_MESA = ?");
		// params.add(ab18a01s00.getT01IdMesa());
		// }
		// if (ab18a01s00 != null && ab18a01s00.getT01FechaProgrEnvio() != null)
		// {
		// where.append(" AND t1.T01_FECHA_PROGR_ENVIO = ?");
		// params.add(ab18a01s00.getT01FechaProgrEnvio());
		// }
		// if (ab18a01s00 != null && ab18a01s00.getT01NumIntentos() != null) {
		// where.append(" AND t1.T01_NUM_INTENTOS = ?");
		// params.add(ab18a01s00.getT01NumIntentos());
		// }
		// if (ab18a01s00 != null && ab18a01s00.getT01DatosError() != null) {
		// where.append(" AND UPPER(t1.T01_DATOS_ERROR) like ? ESCAPE  '\\'");
		// if (startsWith) {
		// params.add(ab18a01s00.getT01DatosError().toUpperCase() + "%");
		// } else {
		// params.add("%" + ab18a01s00.getT01DatosError().toUpperCase()
		// + "%");
		// }
		// where.append(" AND t1.T01_DATOS_ERROR IS NOT NULL");
		// }
		// if (ab18a01s00 != null && ab18a01s00.getT01EstadoTram() != null) {
		// where.append(" AND UPPER(t1.T01_ESTADO_TRAM) like ? ESCAPE  '\\'");
		// if (startsWith) {
		// params.add(ab18a01s00.getT01EstadoTram().toUpperCase() + "%");
		// } else {
		// params.add("%" + ab18a01s00.getT01EstadoTram().toUpperCase()
		// + "%");
		// }
		// where.append(" AND t1.T01_ESTADO_TRAM IS NOT NULL");
		// }
		// if (ab18a01s00 != null && ab18a01s00.getT01CodExpediente() != null) {
		// where.append(" AND UPPER(t1.T01_COD_EXPEDIENTE) like ? ESCAPE  '\\'");
		// if (startsWith) {
		// params.add(ab18a01s00.getT01CodExpediente().toUpperCase() + "%");
		// } else {
		// params.add("%" + ab18a01s00.getT01CodExpediente().toUpperCase()
		// + "%");
		// }
		// where.append(" AND t1.T01_COD_EXPEDIENTE IS NOT NULL");
		// }
		// if (ab18a01s00 != null && ab18a01s00.getAb18a14s00() != null
		// && ab18a01s00.getAb18a14s00().getT01IdPeticionEnvio() != null) {
		// where.append(" AND t7.T01_ID_PETICION_ENVIO = ?");
		// params.add(ab18a01s00.getAb18a14s00().getT01IdPeticionEnvio());
		// }
		// if (ab18a01s00 != null && ab18a01s00.getAb18a14s00() != null
		// && ab18a01s00.getAb18a14s00().getT14IdPublicacionWs() != null) {
		// where.append(" AND t7.T14_ID_PUBLICACION_WS = ?");
		// params.add(ab18a01s00.getAb18a14s00().getT14IdPublicacionWs());
		// }
		// if (ab18a01s00 != null
		// && ab18a01s00.getAb18a14s00() != null
		// && ab18a01s00.getAb18a14s00().getT14FechaPublicacionWs() != null) {
		// where.append(" AND t7.T14_FECHA_PUBLICACION_WS = ?");
		// params.add(ab18a01s00.getAb18a14s00().getT14FechaPublicacionWs());
		// }
		// if (ab18a01s00 != null
		// && ab18a01s00.getAb18a14s00() != null
		// && ab18a01s00.getAb18a14s00().getT14CodDocPublicacionWs() != null) {
		// where.append(" AND UPPER(t7.T14_COD_DOC_PUBLICACION_WS) like ? ESCAPE  '\\'");
		// if (startsWith) {
		// params.add(ab18a01s00.getAb18a14s00()
		// .getT14CodDocPublicacionWs().toUpperCase()
		// + "%");
		// } else {
		// params.add("%"
		// + ab18a01s00.getAb18a14s00()
		// .getT14CodDocPublicacionWs().toUpperCase()
		// + "%");
		// }
		// where.append(" AND t7.T14_COD_DOC_PUBLICACION_WS IS NOT NULL");
		// }

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de XXXX

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	@Override
	public Ab18aPeticionEnvio findIfExists(Ab18aPeticionEnvio peticionAux) throws Exception {
		String query = "SELECT t1.T01_ID_PETICION_ENVIO T01IDPETICIONENVIO, "
				+ "t1.T01_FECHA_ALTA T01FECHAALTA, "
				+ "t1.T01_ANUNCIO_ZIP T01ANUNCIOZIP, "
				+ "t1.T01_ANUNCIO_XML T01ANUNCIOXML, "
				+ "t1.T01_ID_PODER T01IDPODER, "
				+ "t1.T01_ID_ENTIDAD_IMP T01IDENTIDADIMP, "
				+ "t1.T01_ID_ORGANO T01IDORGANO, "
				+ "t1.T01_ID_ENTIDAD_TRAM T01IDENTIDADTRAM, "
				+ "t1.T01_ID_MESA T01IDMESA, "
				+ "t1.T01_FECHA_PROGR_ENVIO T01FECHAPROGRENVIO, "
				+ "t1.T01_NUM_INTENTOS T01NUMINTENTOS, "
				+ "t1.T01_DATOS_ERROR T01DATOSERROR, "
				+ "t1.T01_ESTADO_TRAM T01ESTADOTRAM, "
				+ "t1.T01_COD_EXPEDIENTE T01CODEXPEDIENTE, "
				+ "t1.T01_RESULT_VALID_LOGICA T01RESULTVALIDLOGICA, "
				+ "t1.T01_ANUNCIO_XML_CONVERTIDO T01ANUNCIOXMLCONVERTIDO, "
				+ "t2.T06_ID_BOLETIN T06IDBOLETIN, "
				+ "t3.T02_ID_TIPO_ENVIO T02IDTIPOENVIO, "
				+ "t4.T07_ID_TICKET T07IDTICKET, t5.T03_ID_APLICACION T03IDAPLICACION,t6.T11_ID_ESTADO T11IDESTADO, t7.T01_ID_PETICION_ENVIO T01IDPETICIONENVIO, t4.T03_ID_APLICACION T03IDAPLICACION FROM AB18A01S00 t1 , AB18A06S00 t2 , AB18A02S00 t3 , AB18A07S00 t4 , AB18A03S00 t5 , AB18A11S00 t6 , AB18A14S00 t7  WHERE t1.T07_ID_TICKET = ? AND t1.T03_ID_APLICACION = ?   AND t1.T06_ID_BOLETIN= t2.T06_ID_BOLETIN(+) AND t1.T02_ID_TIPO_ENVIO= t3.T02_ID_TIPO_ENVIO(+) AND t1.T07_ID_TICKET= t4.T07_ID_TICKET(+) AND t1.T03_ID_APLICACION= t5.T03_ID_APLICACION(+) AND t1.T11_ID_ESTADO= t6.T11_ID_ESTADO(+) AND t1.T01_ID_PETICION_ENVIO= t7.T01_ID_PETICION_ENVIO(+)";

		List<Ab18aPeticionEnvio> ab18a01s00List = this.jdbcTemplate.query(query, this.rwMap, peticionAux.getT07IdTicket(),
				peticionAux.getT03IdOrigen());
		return (Ab18aPeticionEnvio) DataAccessUtils.uniqueResult(ab18a01s00List);
	}

	@Override
	@Transactional(readOnly = true)
	public List<Ab18aEnvio> findPeticionesCuadro(Ab18aFiltroMonitor filtroMonitor, Ab18aUsuario usuario, JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT DISTINCT T1.T01_ID_PETICION_ENVIO IDPETICION, T1.T11_ID_ESTADO IDESTADOPETICION, T1.T01_PARALIZADA PARALIZADO, T1.T01_COD_EXPEDIENTE CODEXPEDIENTE, T6.T06_DESC DESCBOLETIN, T2.T02_DESC_ES DESCTIPOENVIO, T11.T11_DESC_ESTADO ESTADOPETICION, T1.T01_FECHA_ALTA FECHAENVIO, T1.T01_FECHA_PROGR_ENVIO fechaProgramadaPublicacion, T14.T14_FECHA_PUBLICACION_WS FECHAPUBLICACION FROM AB18A01S00 T1 ");
		query.append("INNER JOIN AB18A06S00 T6 ON T1.T06_ID_BOLETIN = T6.T06_ID_BOLETIN ");
		query.append("INNER JOIN AB18A02S00 T2 ON T2.T02_ID_TIPO_ENVIO = T1.T02_ID_TIPO_ENVIO ");
		query.append("INNER JOIN AB18A07S00 T7 ON T7.T07_ID_TICKET = T7.T07_ID_TICKET ");
		query.append("INNER JOIN AB18A11S00 T11 ON T11.T11_ID_ESTADO = T1.T11_ID_ESTADO ");
		query.append("LEFT OUTER JOIN AB18A13S00 T13 ON T1.T01_ID_PETICION_ENVIO = T13.T01_ID_PETICION_ENVIO ");
		query.append("LEFT OUTER JOIN AB18A14S00 T14 ON T1.T01_ID_PETICION_ENVIO = T14.T01_ID_PETICION_ENVIO ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMapFiltro(filtroMonitor, usuario, false);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Ab18aEnvio>) this.jdbcTemplate.query(query.toString(), this.rwMapEnvio, params.toArray());
	}

	@Override
	public Long findAllCount(Ab18aFiltroMonitor filtroMonitor, Ab18aUsuario usuario) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM (SELECT DISTINCT T1.T01_ID_PETICION_ENVIO IDPETICION, T1.T01_COD_EXPEDIENTE CODEXPEDIENTE, T6.T06_DESC DESCBOLETIN, T2.T02_DESC_ES DESCTIPOENVIO, T11.T11_DESC_ESTADO ESTADOPETICION, T1.T01_FECHA_ALTA FECHAENVIO, T1.T01_FECHA_PROGR_ENVIO FECHAPROG, T14.T14_FECHA_PUBLICACION_WS FECHAPUBLICACION FROM AB18A01S00 T1 ");
		query.append("INNER JOIN AB18A06S00 T6 ON T1.T06_ID_BOLETIN = T6.T06_ID_BOLETIN ");
		query.append("INNER JOIN AB18A02S00 T2 ON T2.T02_ID_TIPO_ENVIO = T1.T02_ID_TIPO_ENVIO ");
		query.append("INNER JOIN AB18A07S00 T7 ON T7.T07_ID_TICKET = T7.T07_ID_TICKET ");
		query.append("INNER JOIN AB18A11S00 T11 ON T11.T11_ID_ESTADO = T1.T11_ID_ESTADO ");
		query.append("LEFT OUTER JOIN AB18A13S00 T13 ON T1.T01_ID_PETICION_ENVIO = T13.T01_ID_PETICION_ENVIO ");
		query.append("LEFT OUTER JOIN AB18A14S00 T14 ON T1.T01_ID_PETICION_ENVIO = T14.T01_ID_PETICION_ENVIO ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMapFiltro(filtroMonitor, usuario, true);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	private Map<String, ?> getWhereMapFiltro(Ab18aFiltroMonitor filtroMonitor, Ab18aUsuario usuario, boolean isCount) {

		StringBuilder where = new StringBuilder(Ab18aTipoBoletinDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (filtroMonitor != null && Utilidades.notNullAndNotEmpty(filtroMonitor.getCodExpediente())) {
			where.append(" AND UPPER(T1.T01_COD_EXPEDIENTE) like ?");
			params.add("%" + Utilidades.filtroLikeCaracterEspecial(filtroMonitor.getCodExpediente().toUpperCase()) + "%");
			where.append(" AND T1.T01_COD_EXPEDIENTE IS NOT NULL");
		}

		if (filtroMonitor != null && Utilidades.notNullAndNotEmpty(filtroMonitor.getIdBoletin())) {
			where.append(" AND T1.T06_ID_BOLETIN = ?");
			params.add(filtroMonitor.getIdBoletin());
		}

		if (filtroMonitor != null && Utilidades.notNullAndNotEmpty(filtroMonitor.getIdEstadoPeticion())) {
			where.append(" AND T1.T11_ID_ESTADO = ?");
			params.add(filtroMonitor.getIdEstadoPeticion());
		}

		if (filtroMonitor != null && Utilidades.notNullAndNotEmpty(filtroMonitor.getIdTicketPeticion())) {
			where.append(" AND T1.T07_ID_TICKET = ?");
			params.add(filtroMonitor.getIdTicketPeticion());
		}

		if (filtroMonitor != null && Utilidades.notNullAndNotEmpty(filtroMonitor.getIdTipoEnvio())) {
			where.append(" AND T1.T02_ID_TIPO_ENVIO = ?");
			params.add(filtroMonitor.getIdTipoEnvio());
		}

		if (filtroMonitor != null && Utilidades.notNullAndNotEmpty(filtroMonitor.getIdAmbito())) {
			if (Utilidades.notNullAndNotZero(Integer.valueOf(filtroMonitor.getIdAmbito()))) {
				String dni = usuario.getDni();
				if (this.usuarioAdministrador(usuario.getPerfiles())) {
					dni = "";
				}
				List<Ab18aObjetoWSBean> listaPoderesAmbito = Utilidades.obtenerListaPoderes(dni, filtroMonitor.getIdAmbito(), Constantes.CTE_FALSE,
						Utilidades.getIdiomaActual());
				if (listaPoderesAmbito != null && !listaPoderesAmbito.isEmpty()) {
					StringBuilder builderPoder = new StringBuilder();

					where.append(" AND T1.T01_ID_PODER IN (");

					for (int i = 0; i < listaPoderesAmbito.size(); i++) {
						builderPoder.append("?,");
						params.add(String.valueOf(listaPoderesAmbito.get(i).getId()));
					}

					where.append(builderPoder.deleteCharAt(builderPoder.length() - 1).toString() + ")");
				} else {
					where.append(" AND T1.T01_ID_PODER IS NULL ");
				}
			}
		}

		if (filtroMonitor != null && Utilidades.notNullAndNotEmpty(filtroMonitor.getIdPoder())) {
			if (Utilidades.notNullAndNotZero(Integer.valueOf(filtroMonitor.getIdPoder()))) {
				where.append(" AND T1.T01_ID_PODER = ?");
				params.add(filtroMonitor.getIdPoder());
			}
		}

		if (filtroMonitor != null && Utilidades.notNullAndNotEmpty(filtroMonitor.getIdEntidadImpulsora())) {
			if (Utilidades.notNullAndNotZero(Integer.valueOf(filtroMonitor.getIdEntidadImpulsora()))) {
				where.append(" AND T1.T01_ID_ENTIDAD_IMP = ?");
				params.add(this.obtenerCodigoDepartamento(filtroMonitor.getIdEntidadImpulsora()));
			}
		}

		if (filtroMonitor != null && Utilidades.notNullAndNotEmpty(filtroMonitor.getIdOrgano())) {
			if (Utilidades.notNullAndNotZero(Integer.valueOf(filtroMonitor.getIdOrgano()))) {
				where.append(" AND T1.T01_ID_ORGANO = ?");
				params.add(this.obtenerCodigoOrgano(filtroMonitor.getIdOrgano()));
			}
		}

		if (!usuarioAdministrador(usuario.getPerfiles())) {
			/* VINCULACIONES */
			/* PODER */

			List<TipoPoder> listaPoder = usuario.getPoderes();
			if (listaPoder != null && !listaPoder.isEmpty()) {

				StringBuilder builderPoder = new StringBuilder();

				where.append(" AND T1.T01_ID_PODER IN (");

				for (int i = 0; i < listaPoder.size(); i++) {
					builderPoder.append("?,");
					params.add(listaPoder.get(i).getCodigoElemento());
				}

				where.append(builderPoder.deleteCharAt(builderPoder.length() - 1).toString() + ")");
			} else {
				where.append(" AND T1.T01_ID_PODER IS NULL ");
			}

			List<TipoEntidadImpulsora> listaEntidadImp = usuario.getEntidadesImpulsoras();
			if (listaEntidadImp != null && !listaEntidadImp.isEmpty()) {
				/* ENTIDAD IMP */
				where.append(" AND T1.T01_ID_ENTIDAD_IMP IN (");

				StringBuilder builderEntidad = new StringBuilder();

				for (int i = 0; i < listaEntidadImp.size(); i++) {
					builderEntidad.append("?,");
					params.add(this.obtenerCodigoDepartamento(listaEntidadImp.get(i).getCodigoElemento()));
				}

				where.append(builderEntidad.deleteCharAt(builderEntidad.length() - 1).toString() + ")");
			} else {
				where.append(" AND T1.T01_ID_ENTIDAD_IMP IS NULL ");
			}
		}

		/* FECHAS */
		if (filtroMonitor != null && Utilidades.notNullAndNotEmpty(filtroMonitor.getFechaEnvioDesde())) {
			where.append(" AND to_date(T1.T01_FECHA_ALTA) >= to_date(?)");
			params.add(new java.sql.Date(filtroMonitor.getFechaEnvioDesde().getTime()));
		}

		if (filtroMonitor != null && Utilidades.notNullAndNotEmpty(filtroMonitor.getFechaEnvioHasta())) {
			where.append(" AND to_date(T1.T01_FECHA_ALTA) <= to_date(?)");
			params.add(new java.sql.Date(filtroMonitor.getFechaEnvioHasta().getTime()));
		}

		if (filtroMonitor != null && filtroMonitor.getFechaProgramadaPublicacionDesde() != null) {
			where.append(" AND T1.T01_FECHA_PROGR_ENVIO >= to_date(?)");
			params.add(new java.sql.Date(filtroMonitor.getFechaProgramadaPublicacionDesde().getTime()));
		}

		if (filtroMonitor != null && filtroMonitor.getFechaProgramadaPublicacionHasta() != null) {
			where.append(" AND to_date(T1.T01_FECHA_PROGR_ENVIO) <= to_date(?)");
			params.add(new java.sql.Date(filtroMonitor.getFechaProgramadaPublicacionHasta().getTime()));
		}

		if (filtroMonitor != null && filtroMonitor.getFechaPublicacionDesde() != null) {
			where.append(" AND to_date(T14.T14_FECHA_PUBLICACION_WS) >= to_date(?)");
			params.add(new java.sql.Date(filtroMonitor.getFechaPublicacionDesde().getTime()));
		}

		if (filtroMonitor != null && filtroMonitor.getFechaPublicacionHasta() != null) {
			where.append(" AND to_date(T14.T14_FECHA_PUBLICACION_WS) <= to_date(?)");
			params.add(new java.sql.Date(filtroMonitor.getFechaPublicacionHasta().getTime()));
		}

		if (filtroMonitor != null && Utilidades.notNullAndNotZero(filtroMonitor.getIdPeticion())) {
			where.append(" AND T1.T01_ID_PETICION_ENVIO = ?");
			params.add(filtroMonitor.getIdPeticion());
		}

		if (filtroMonitor != null && Utilidades.notNullAndNotZero(filtroMonitor.getIdEstadoTramitacion())) {
			where.append(" AND T1.T01_ESTADO_TRAM = ?");
			params.add(filtroMonitor.getIdEstadoTramitacion());
		}

		where.append(" AND T1.T01_PARALIZADA = ?");
		params.add(filtroMonitor.getParalizada());

		if (isCount) {
			where.append(")");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// /** Actualiza el estado de una petición **/
	// public void updateEstado(Ab18aPeticionEnvio ab18a01s00) {
	// String query =
	// "UPDATE AB18A01S00 SET T11_ID_ESTADO = ? WHERE T01_ID_PETICION_ENVIO = ?";
	//
	// this.jdbcTemplate.update(query, ab18a01s00.getT11IdEstado(),
	// ab18a01s00.getT01IdPeticionEnvio());
	// }

	public Ab18aPeticionEnvio findZipById(Integer idPeticionEnvio) {

		String query = "SELECT t1.T01_ID_PETICION_ENVIO T01IDPETICIONENVIO, " + "t1.T01_FECHA_ALTA T01FECHAALTA, "
				+ "t1.T01_ANUNCIO_ZIP T01ANUNCIOZIP, " + "t1.T01_ANUNCIO_XML T01ANUNCIOXML, " + "t1.T01_ID_PODER T01IDPODER, "
				+ "t1.T01_ID_ENTIDAD_IMP T01IDENTIDADIMP, " + "t1.T01_ID_ORGANO T01IDORGANO, " + "t1.T01_ID_ENTIDAD_TRAM T01IDENTIDADTRAM, "
				+ "t1.T01_ID_MESA T01IDMESA, " + "t1.T01_FECHA_PROGR_ENVIO T01FECHAPROGRENVIO, " + "t1.T01_NUM_INTENTOS T01NUMINTENTOS, "
				+ "t1.T01_DATOS_ERROR T01DATOSERROR, " + "t1.T01_ESTADO_TRAM T01ESTADOTRAM, " + "t1.T01_COD_EXPEDIENTE T01CODEXPEDIENTE, "
				+ "t1.T01_RESULT_VALID_LOGICA T01RESULTVALIDLOGICA, " + "t1.T01_ANUNCIO_XML_CONVERTIDO T01ANUNCIOXMLCONVERTIDO "
				+ "FROM AB18A01S00 t1 WHERE t1.T01_ID_PETICION_ENVIO = ?";

		List<Ab18aPeticionEnvio> ab18a01s00List = this.jdbcTemplate.query(query, this.rwMapZip, idPeticionEnvio);
		return (Ab18aPeticionEnvio) DataAccessUtils.uniqueResult(ab18a01s00List);
	}

	public void paralizarReanudarPeticion(Ab18aPeticionEnvio peticion) {
		String query = "UPDATE AB18A01S00 SET T01_PARALIZADA = ? WHERE T01_ID_PETICION_ENVIO = ?";

		this.jdbcTemplate.update(query, peticion.getT01Paralizada(), peticion.getT01IdPeticionEnvio());
	}

	public List<Ab18aIncoherencia> findIncoherencias(Ab18aIncoherencia filtroIncoherencia, Ab18aUsuario usuario, JQGridRequestDto jqGridRequestDto) {

		StringBuilder query = new StringBuilder(
				"SELECT DISTINCT t1.T18_ID_INCOHERENCIA T18IDINCO, t1.T18_COD_EXPEDIENTE T18CODEXP, t2.T19_DESC_TIPO_INCOHERENCIA T19DESCTIPO, t1.T18_FECHA_BAJA T18FECHABAJA ");
		query.append("FROM AB18A18S00 t1 INNER JOIN AB18A19S00 t2 ON t1.T18_ID_TIPO_INCOHERENCIA = t2.T19_ID_TIPO_INCOHERENCIA INNER JOIN AB18A01S00 t3 ON t1.T18_COD_EXPEDIENTE = T3.T01_COD_EXPEDIENTE");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMapIncoherencia(filtroIncoherencia, usuario);
		StringBuilder where = new StringBuilder(" WHERE t1.T18_FECHA_BAJA IS NULL ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Ab18aIncoherencia>) this.jdbcTemplate.query(query.toString(), this.rwMapIncoherencias, params.toArray());
	}

	private Map<String, ?> getWhereMapIncoherencia(Ab18aIncoherencia filtroIncoherencia, Ab18aUsuario usuario) {

		StringBuilder where = new StringBuilder(Ab18aTipoBoletinDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (Utilidades.notNullAndNotEmpty(filtroIncoherencia.getCodExpediente())) {
			where.append(" AND UPPER(t1.T18_COD_EXPEDIENTE) like ?");
			params.add("%" + Utilidades.filtroLikeCaracterEspecial(filtroIncoherencia.getCodExpediente().toUpperCase()) + "%");
			where.append(" AND t1.T18_COD_EXPEDIENTE IS NOT NULL");
		}

		if (!this.usuarioAdministrador(usuario.getPerfiles())) {
			/* VINCULACIONES */
			/* PODER */

			List<TipoPoder> listaPoder = usuario.getPoderes();
			if (listaPoder != null && !listaPoder.isEmpty()) {

				StringBuilder builderPoder = new StringBuilder();

				where.append(" AND T3.T01_ID_PODER IN (");

				for (int i = 0; i < listaPoder.size(); i++) {
					builderPoder.append("?,");
					params.add(listaPoder.get(i).getCodigoElemento());
				}

				where.append(builderPoder.deleteCharAt(builderPoder.length() - 1).toString() + ")");
			} else {
				where.append(" AND T3.T01_ID_PODER IS NULL ");
			}

			List<TipoEntidadImpulsora> listaEntidadImp = usuario.getEntidadesImpulsoras();
			if (listaEntidadImp != null && !listaEntidadImp.isEmpty()) {
				/* ENTIDAD IMP */
				where.append(" AND T3.T01_ID_ENTIDAD_IMP IN (");

				StringBuilder builderEntidad = new StringBuilder();

				for (int i = 0; i < listaEntidadImp.size(); i++) {
					builderEntidad.append("?,");
					params.add(this.obtenerCodigoDepartamento(listaEntidadImp.get(i).getCodigoElemento()));
				}

				where.append(builderEntidad.deleteCharAt(builderEntidad.length() - 1).toString() + ")");
			} else {
				where.append(" AND T3.T01_ID_ENTIDAD_IMP IS NULL ");
			}
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * Counts rows in the Ab18a18s00 table.
	 * 
	 * @param filtroIncoherencia
	 *            Ab18a18s00
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCountIncoherencias(Ab18aIncoherencia filtroIncoherencia, Ab18aUsuario usuario) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM (SELECT DISTINCT t1.T18_ID_INCOHERENCIA T18IDINCO, t1.T18_COD_EXPEDIENTE T18CODEXP, t2.T19_DESC_TIPO_INCOHERENCIA T19DESCTIPO, t1.T18_FECHA_BAJA T18FECHABAJA FROM AB18A18S00 t1 INNER JOIN AB18A19S00 t2 ON t1.T18_ID_TIPO_INCOHERENCIA = t2.T19_ID_TIPO_INCOHERENCIA INNER JOIN AB18A01S00 t3 ON t1.T18_COD_EXPEDIENTE = T3.T01_COD_EXPEDIENTE");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMapIncoherencia(filtroIncoherencia, usuario);
		StringBuilder where = new StringBuilder(" WHERE t1.T18_FECHA_BAJA IS NULL ");
		where.append(mapaWhere.get("query"));
		query.append(where + ")");

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	public void deshabilitarIncoherencia(String codExpediente) {
		StringBuilder query = new StringBuilder(
				"UPDATE AB18A18S00 SET T18_FECHA_BAJA = CURRENT_TIMESTAMP WHERE T18_COD_EXPEDIENTE = ? AND T18_FECHA_BAJA IS NULL");

		this.jdbcTemplate.update(query.toString(), codExpediente);
	}

	@Override
	public Ab18aPeticionDetalle findDetallePeticionById(Integer idPeticion) throws Exception {
		StringBuilder query = new StringBuilder(
				"SELECT T1.T01_ID_PETICION_ENVIO T01IDPETICIONENVIO, T2.T02_DESC_ES TIPOENVIODESC, T6.T06_DESC BOLETINDESC,");
		query.append(" T11.T11_DESC_ESTADO DESCESTADO, T1.T01_FECHA_ALTA FECHAALTA, T1.T01_FECHA_PROGR_ENVIO FECHAPROG,");
		query.append(" T15.T15_DESC_ESTADO_TRAMITACION DESCESTADOTRAM, T1.T01_COD_EXPEDIENTE CODEXPEDIENTE, ");
		query.append(" T13.T13_ID_ENVIO_WS IDENVIOWS, T13.T13_FECHA_RECEP_WS FECHARECEP, T13.T13_ESTADO_ENVIO_WS ESTADOENVIO,");
		query.append(" T13.T13_ERROR_ENVIO_WS ERRORENVIO, T13.T13_FECHA_MODIF_ENVIO_WS FECHAMODIF, T14.T14_FECHA_PUBLICACION_WS FECHAPUBLIC,");
		query.append(" T14.T14_COD_DOC_PUBLICACION_WS CODPUBLICACION, T8.T08_LINK LINK ");
		query.append(" FROM AB18A01S00 T1 INNER JOIN AB18A11S00 T11 ON T1.T11_ID_ESTADO = T11.T11_ID_ESTADO");
		query.append(" INNER JOIN AB18A02S00 T2 ON T1.T02_ID_TIPO_ENVIO = T2.T02_ID_TIPO_ENVIO");
		query.append(" INNER JOIN AB18A06S00 T6 ON T1.T06_ID_BOLETIN = T6.T06_ID_BOLETIN");
		query.append(" INNER JOIN AB18A15S00 T15 ON T1.T01_ESTADO_TRAM = T15.T15_ID_ESTADO_TRAMITACION");
		query.append(" LEFT OUTER JOIN AB18A13S00 T13 ON T1.T01_ID_PETICION_ENVIO = T13.T01_ID_PETICION_ENVIO");
		query.append(" LEFT OUTER JOIN AB18A14S00 T14 ON T1.T01_ID_PETICION_ENVIO = T14.T01_ID_PETICION_ENVIO");
		query.append(" LEFT OUTER JOIN AB18A08S00 T8 ON T1.T01_ID_PETICION_ENVIO = T8.T01_ID_PETICION_ENVIO");
		query.append(" WHERE T1.T01_ID_PETICION_ENVIO = ?");

		List<Ab18aPeticionDetalle> ab18a01s00List = this.jdbcTemplate.query(query.toString(), this.rwMapDetalle, idPeticion);
		return (Ab18aPeticionDetalle) DataAccessUtils.uniqueResult(ab18a01s00List);
	}

	private boolean usuarioAdministrador(List<TipoPerfil> listaPerfiles) {
		boolean esAdmin = false;
		if (listaPerfiles != null && !listaPerfiles.isEmpty()) {
			TipoPerfil perfil = null;
			Iterator itPerfiles = listaPerfiles.iterator();
			while (itPerfiles.hasNext() && !esAdmin) {
				perfil = (TipoPerfil) itPerfiles.next();
				if (perfil.getCodigoPerfil().equals(Constantes.COD_ADMINISTRADOR_PERFIL)) {
					esAdmin = true;
				}
			}
		}

		return esAdmin;
	}

	private String obtenerCodigoDepartamento(String idEntidadImp) {
		StringBuilder query = new StringBuilder("SELECT t1.CODDEPARTAMENTO_010 CODDEPARTAMENTO FROM V79J.V7910S00 t1 WHERE t1.IDDEPARTAMENTO_010 = ?");

		List<String> resultList = this.jdbcTemplate.query(query.toString(), this.rwMapString, idEntidadImp);
		return (String) DataAccessUtils.uniqueResult(resultList);
	}

	private String obtenerCodigoOrgano(String idOrgano) {
		StringBuilder query = new StringBuilder("SELECT t1.CODORGANO_011 CODDEPARTAMENTO FROM V79J.V7911S00 t1 WHERE t1.IDORGANO_011 = ?");

		List<String> resultList = this.jdbcTemplate.query(query.toString(), this.rwMapString, idOrgano);
		return (String) DataAccessUtils.uniqueResult(resultList);
	}

	@Override
	public void reactivar(Integer idPeticion) throws Exception {
		StringBuilder query = new StringBuilder("UPDATE AB18A01S00 SET T11_ID_ESTADO = 1, T01_NUM_INTENTOS = 0 WHERE T01_ID_PETICION_ENVIO = ?");

		this.jdbcTemplate.update(query.toString(), idPeticion);
	}

	@Override
	public Integer findNumIntentosById(Integer idPeticion) throws Exception {
		StringBuilder query = new StringBuilder("SELECT T01_NUM_INTENTOS NUMINTENTOS FROM AB18A01S00 WHERE T01_ID_PETICION_ENVIO = ?");

		List<Integer> resultList = this.jdbcTemplate.query(query.toString(), this.rwMapInteger, idPeticion);
		return (Integer) DataAccessUtils.uniqueResult(resultList);
	}
}
